package com.bxm.datapark.web.model.old.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.warcar.utils.Constants;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * @author allen
 * @date 2017-12-05
 */
public class TicketOnoff implements Serializable {
    private static final long serialVersionUID = 1242446433401411816L;

    public static final byte ONOFF_ON = Constants.YES;
    public static final byte ONOFF_OFF = Constants.NO;

    public static final int TYPE_NOIMEI = 1;
    public static final int TYPE_INVALIDIMEI = 2;

    @JSONField(serialize = false, deserialize = false)
    private BigInteger ticketId;
    private Byte onoff;
    private Integer type;
    private String value;

    @JSONField(serialize = false, deserialize = false)
    public boolean isOff() {
        return null == onoff || onoff.byteValue() == ONOFF_OFF;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isOn() {
        return ! isOff();
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public Byte getOnoff() {
        return onoff;
    }

    public void setOnoff(Byte onoff) {
        this.onoff = onoff;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
