package com.bxm.datapark.web.model.old.vo.release;

import org.springframework.data.mongodb.core.mapping.Field;

import java.text.DecimalFormat;

/**
 * 整合业务实体
 * @author gaoshihao
 * @version v1.1.4_Report
 * @fileName com.bxm.datapark.dal.mongo.vo.release.BasePutAnalysisEntity.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-05-30 20:54:00
 * @modifier gaoshihao
 * @updated 2018-05-30 20:54:00
 */
public class BasePutAnalysisEntity {

    /**
     * 编号
     */
    private String number;

    @Field("_id")
    private String id;
    /**
     * 开发者标志
     */
    @Field("app_key")
    private String appKey;

    /**
     * 广告位id
     */

    @Field("position_id")
    private String positionId;

    /**
     * 广告id
     */

    @Field("advertising_id")
    private String advertisingId;

    /**
     * 统计日期
     */
    @Field("date_time")
    private String dateTime;

    /**
     *发券数
     */
    @Field("curl_count")
    private Integer curlCount;
    /**
     * 点击数
     */
    @Field("click_count")
    private Integer clickCount;
    /**
     * 效果监测数
     */
    @Field("effect_monitor_count")
    private Integer effectMonitorCount;

    /**
     * cvr
     */
    @Field("cvr")
    private Double cvr;
    /**
     * 广告总收入
     */
    @Field("advertising_income_total")
    private Double advertisingIncomeTotal;
    /**
     *点击arpu
     */
    @Field("click_arpu")
    private Double clickArpu;
    /**
     * 发券arpu
     */
    @Field("curl_arpu")
    private Double curlArpu;
    /**
     * 效果成本
     */
    @Field("cost_effect")
    private Double costEffect;
    /**
     * 点击率
     */
    @Field("click_rate")
    private Double clickRate;
    /**
     * 创建时间
     */
    @Field("create_time")
    private String createTime;

    /**
     * 曝光单价
     */
    private Double exposurePrice;


    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAdvertisingId() {
        return advertisingId;
    }

    public void setAdvertisingId(String advertisingId) {
        this.advertisingId = advertisingId;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public Integer getCurlCount() {
        return curlCount;
    }

    public void setCurlCount(Integer curlCount) {
        this.curlCount = curlCount;
    }

    public Integer getClickCount() {
        return clickCount;
    }

    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    public Integer getEffectMonitorCount() {
        return effectMonitorCount;
    }

    public void setEffectMonitorCount(Integer effectMonitorCount) {
        this.effectMonitorCount = effectMonitorCount;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    /**
     * 此处 格式化 广告总收入 double
     * @return
     */
    public Double getAdvertisingIncomeTotal() {
        return  Double.valueOf(fomtDouble(advertisingIncomeTotal)) ;
    }

    public void setAdvertisingIncomeTotal(Double advertisingIncomeTotal) {
        this.advertisingIncomeTotal = advertisingIncomeTotal;
    }

    public Double getClickArpu() {
        return clickArpu;
    }

    public void setClickArpu(Double clickArpu) {
        this.clickArpu = clickArpu;
    }

    public Double getCurlArpu() {
        return curlArpu;
    }

    public void setCurlArpu(Double curlArpu) {
        this.curlArpu = curlArpu;
    }

    public Double getCostEffect() {
        return costEffect;
    }

    public void setCostEffect(Double costEffect) {
        this.costEffect = costEffect;
    }

    public Double getClickRate() {
        return clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Double getExposurePrice() {
        return exposurePrice;
    }

    public void setExposurePrice(Double exposurePrice) {
        this.exposurePrice = exposurePrice;
    }

    /**
     * 格式化 double
     * @param value
     * @return
     */
    private String fomtDouble(Double value) {
        if(value==null){ return  "0.0";}
        DecimalFormat numberFormat  = new DecimalFormat("#.00");
        return numberFormat.format(value);
    }
}
