package com.bxm.datapark.constant;

/**
 * 操作 mongodb 的常量
 *
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.constant.MongoConstant.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-08 10:31:00
 * @modifier 董朱旭
 * @updated 2018-01-08 10:31:00
 * @description
 */
public class MongoConstant {
    /**
     * 时间默认格式
     */
    public static final String DATE_FOMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";

    /**
     * 点击时间
     */
    public static final String CLICKTIME = "clicktime";

    /**
     * 发券
     */
    public static final Integer SEND_PV = Integer.valueOf(5);
    /**
     * 券曝光
     */
    public static final Integer OPEN_PV = Integer.valueOf(6);
    /**
     * 券点击
     */
    public static final Integer CLICK_PV = Integer.valueOf(7);
    /**
     * 统计类型
     */
    public static final String MODELTYPE = "modeltype";
    /**
     * 券 ID
     */
    public static final String PREID = "preid";
    /**
     * 开发者标志
     */
    public static final String APPKEY = "appkey";
    public static final String APPKEY_VO = "appKey";
    /**
     * 子渠道标志
     */
    public static final String BUSINESS = "business";
    /**
     * 统计数目
     */
    public static final String COUNT = "count";
    public static final String VAILD = "vaild";

    /**
     * 默认插入最大数量
     */
    public static final Integer DEFAULT_COUNT = 3000;

    public static final Integer BAR_ONE= Integer.valueOf(-1);
    public static final Integer ZERO=Integer.valueOf(0);
    public static final Integer ONE=Integer.valueOf(1);
    public static final Integer FOUR=Integer.valueOf(4);
    public static final Integer NINE=Integer.valueOf(9);
    public static final Integer TWENTY_THREE=Integer.valueOf(23);
    public static final Integer ONE_HUNDRED=Integer.valueOf(100);


    /**
     * 空格
     */
    public static String SPACE = " ";

    /**
     * 百分号
     */
    public static final String SIGN="%";

    /**
     * 点
     */
    public static final String POINT=".";
    /**
     * 格式化
     */
    public static final String NUMBER_FOMAT="#.00";


    /**
     * 时间
     */
    public static final String HOURTIME = ":00:00";
    public static final String HOUR = "hour";
    public static final String AD_BUSINESS = ".*ad.*";
    public static final String AD_PARAME = "ad";
    public static final String AD_PARAME_BAR = "ad-";


    /**
     * 集合名称前缀
     */
    public static final String AWARD_DETAIL = "award_detail_";
    public static final String TICKET_CERTIFICATE_COUNT_HOUR = "ticket_certificate_count_hour_";
    public static final String TICKET_APP_COUNT_HOUR = "ticket_app_count_hour_";
    public static final String TICKET_BUSINESS_COUNT_HOUR = "ticket_business_count_hour_";
    public static final String TICKET_COUNT= "ticket_count_";
    public static final String TICKET_COUNT_APP= "ticket_count_app_";
    public static final String TICKET_COUNT_BUSINESS = "ticket_count_business_";
    /**
     * 杠
     */
    public static final String BAR = "-";
    /**
     * 空
     */
    public static final String BLANK = "";
    public static final String COLON = ":";


    /**
     * 广告券按小时维度控制层常量
     */
    public static final String CERTIFICATEID="certificateid";
    public static final String DATETIME="datetime";
    public static final String S_HOUR="sHour";
    public static final String E_HOUR="eHour";
    public static final String PAGE_SIZE="pageSize";
    public static final String PAGE_NUM="pageNum";
    public static final String SORT_NAME="sortName";
    public static final String SORT_TYPE="sortType";


    public static final String ZERO_S="0";
    public static final String BAR_ZERO_S="-0";
    public static final String ONE_S="1";
    public static final String FIVE_S="5";
    public static final String TEN_S="10";
    public static final String DEFAULT_SORT_NAME = "hour";
    public static final String SORT_TYPE_ASC = "asc";
    public static final String SORT_TYPE_DESC = "desc";


    /**
     * pojo
     */
    public static final String SEND_PV_VO="sendPv";
    public static final String CLICK_PV_VO="clickPv";
    public static final String OPEN_PV_VO="openPv";
    public static final String VALID_CLICK_VO="validClick";
    public static final String VALID_CLICK_RATE_VO="validClickRate";
    public static final String CONVERSION_VO="conversion";


    public static final String COUNT_CN="合计";

    public static final String INCOME="income";
    public static final String INCOME_CHANGE="incomeChange";
    public static final String OPEN_PV_AURP="openPvAurp";
    public static final String OPEN_PV_AURP_CHANGE="openPvAurpChange";
    public static final String CLICK_AURP="clickAurp";
    public static final String CLICK_AURP_CHANGE="clickAurpChange";


}
