package com.bxm.datapark.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @detail 聚合枚举
 * @time 2018年1月8日15:22:11
 * @author 董朱旭
 */
public enum SumType {

    CERTIFICATE(0,"礼券维度"),
    CERTIFICATE_APP(1,"开发者维度"),
    CERTIFICATE_APP_BUSINESS(2,"子渠道维度");




    private Integer code;

    private String name;

    private SumType(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }


    /**
     * 所有状态
     *
     * @return
     */
    public static Map<Integer, String> getAllState() {
        SumType[] sts = SumType.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (SumType tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     *
     * @param code
     * @return
     */
    public static String getName(Integer code) {
        try{
            for (SumType state : SumType.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
        }catch (Exception e){
            return "";
        }
        return "未找到字典";
    }
}
