package com.bxm.datapark.service;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.mongodb.config.EnableMongoAuditing;

/**
 * @author allen
 * @date 2017-11-29
 */
@ComponentScan
@SpringBootApplication
@MapperScan(basePackages = "com.bxm.datapark.dal.mapper")
@EnableAutoConfiguration
@EnableMongoAuditing
@ComponentScan(basePackages = "com.bxm.datapark.dal.mongo.dao")
public class DataParkServiceApplication {

    public static void main(String[] args) {
        SpringApplication.run(DataParkServiceApplication.class, args);
    }
}
