package com.bxm.datapark.service.commons.metrics;

import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author allen
 * @since V1.0.0 2018/01/03
 */
@ManagedResource(objectName = "com.bxm.datapark:type=TaskMetrics,name=consumeTime")
public class ConsumeTimeMetrics {

    private final ConcurrentMap<String, AtomicLong> lastTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicLong>();
    /**
     * only collect success invoke.
     */
    private final ConcurrentMap<String, AtomicLong> largestTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicLong>();

    public void increaseTask(String serviceName, long consumingTime) {
        AtomicLong lastTaskConsumeTime = lastTaskConsumeTimeTable.putIfAbsent(serviceName,
                new AtomicLong(0L));
        if (null == lastTaskConsumeTime) {
            lastTaskConsumeTime = lastTaskConsumeTimeTable.get(serviceName);
        }
        lastTaskConsumeTime.set(consumingTime);

        AtomicLong largestTimeContainer = largestTaskConsumeTimeTable.putIfAbsent(
                serviceName, new AtomicLong(0));
        if (null == largestTimeContainer) {
            largestTimeContainer = largestTaskConsumeTimeTable.get(serviceName);
        }

        processLargestTaskConsumeTime(largestTimeContainer, consumingTime);
    }

    private void processLargestTaskConsumeTime(AtomicLong largestTimeContainer, long consumingTime) {
        int retry = 0;
        boolean done = false;
        do {
            long expect = largestTimeContainer.longValue();
            if (consumingTime > expect) {
                done = largestTimeContainer.compareAndSet(expect, consumingTime);
            }
            retry++;
        } while ((!done) && (retry < 3));
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getLastTaskConsumeTimeTable() {
        return lastTaskConsumeTimeTable;
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getLargestTaskConsumeTimeTable() {
        return largestTaskConsumeTimeTable;
    }
}
