package com.bxm.datapark.service.commons.metrics;

import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

/**
 *
 * @author allen
 * @since V1.0.0 2018/01/03
 */
@ManagedResource(objectName = "com.bxm.datapark:type=TaskMetrics,name=counter")
public class CounterMetrics {

    private final ConcurrentMap<String, AtomicLong> successTasks = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, AtomicLong> failTasks = new ConcurrentHashMap<String, AtomicLong>();

    public void incrementSuccessTask(String serviceName) {
        AtomicLong counter = successTasks.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == counter) {
            counter = successTasks.get(serviceName);
        }
        counter.incrementAndGet();
    }

    public void incrementFailTask(String serviceName) {
        AtomicLong counter = failTasks.putIfAbsent(serviceName, new AtomicLong(0L));
        if (null == counter) {
            counter = failTasks.get(serviceName);
        }
        counter.incrementAndGet();
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getSuccessTasks() {
        return successTasks;
    }

    @ManagedAttribute
    public ConcurrentMap<String, AtomicLong> getFailTasks() {
        return failTasks;
    }
}
