package com.bxm.datapark.service.conf;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.Account;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import com.bxm.datapark.service.util.WarnMsgUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author zhangkai
 * @create 2018-01-05 14:18
 **/
@Component
public class DataCollectorManager {

    private DatahubClient client;
    private Map<Enum, RecordSchema> schemaMap = Maps.newHashMap();
    private static final Logger log = LoggerFactory.getLogger(DataCollectorManager.class);

    public enum TOPIC {
        USER_BEHAVIOR("rds_count_awradmsg_detail_2"),
        AD_HIT("count_certifiate_adshop_2");

        final static String PROJECT = "datah_test";
        private String topicName;

        TOPIC(String topicName) {
            this.topicName = topicName;
        }

        private String getName() {
            return this.topicName;
        }
    }

    public DataCollectorManager() {
        Account account = new AliyunAccount("LTAIWvHd4WR8lqbC", "YvSG81iMmZbRjHPE52YVgZcCvtzvEx");
        DatahubConfiguration conf = new DatahubConfiguration(account, "http://dh-cn-hangzhou.aliyuncs.com");
        this.client = new DatahubClient(conf);
        loadSchemaWithTopic();
    }


    private void loadSchemaWithTopic(){
        schemaMap.put(TOPIC.USER_BEHAVIOR,
                client.getTopic(TOPIC.PROJECT, TOPIC.USER_BEHAVIOR.getName()).getRecordSchema());
        schemaMap.put(TOPIC.AD_HIT,
                client.getTopic(TOPIC.PROJECT, TOPIC.AD_HIT.getName()).getRecordSchema());
    }

   public RecordEntry createRecord(TOPIC topic) {
       RecordEntry entry = new RecordEntry(schemaMap.get(topic));
       return entry;
   }

   public void sendRecords(TOPIC topic, List<RecordEntry> records) {
        PutRecordsResult sendResult = client.putRecords(TOPIC.PROJECT, topic.getName(), records, 3);
        if(sendResult.getFailedRecordCount() > 1) {

            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "dataHub error topic:" + topic.getName(), false, null);
            log.error("dataHub error topic:" + topic.getName());
        }
   }

   public void sendRecords(TOPIC topic, RecordEntry recordEntry) {
        PutRecordsResult sendResult = client.putRecords(TOPIC.PROJECT, topic.getName(), Lists.newArrayList(recordEntry), 3);
        if(sendResult.getFailedRecordCount() >= 1) {

            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "dataHub error topic:" + topic.getName(), false, null);
            log.error("dataHub error topic:" + topic.getName());
        }
   }
}
