package com.bxm.datapark.service.controller;

import com.bxm.datapark.dal.model.CountAwradmsgDetail;
import com.bxm.datapark.service.service.CountAwaradMessageService;
import com.bxm.datapark.service.util.CountAwardMaxCompute;
import com.bxm.util.dto.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 广告用户行为接口
 *
 * @author zhangkai
 * @create 2017-12-11 12:00
 **/
@RestController
public class CountAwaradMessageController {

    @Autowired
    private CountAwaradMessageService countAwaradMessageService;

    @Autowired
    private CountAwardMaxCompute maxCompute;

    @RequestMapping(value = "/getCountAwaradMessageById/{countId}", method = RequestMethod.GET)
    public ResultModel<CountAwradmsgDetail> getUserByToken(@PathVariable(value = "countId") String countId) {
        ResultModel<CountAwradmsgDetail> resultModel = new ResultModel<CountAwradmsgDetail>();
        CountAwradmsgDetail countAwradmsgDetail = countAwaradMessageService.getObjectById(countId);
        resultModel.setReturnValue(countAwradmsgDetail);
        return resultModel;
    }

}
