package com.bxm.datapark.service.controller;

import com.bxm.datapark.dal.model.ext.AreaCode;
import com.bxm.datapark.dal.model.ext.CountriesRegions;
import com.bxm.datapark.service.service.ProvinceCityService;
import com.bxm.datapark.service.util.RedisClient;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author zhangkai
 * @create 2017-12-12 16:48
 **/
@RestController
public class ProvinceCityController {

    @Autowired
    private ProvinceCityService provinceCityService;

    @Autowired
    private RedisClient redisClient;



    @RequestMapping(value = "/getProvinceCity", method = RequestMethod.GET)
    public ResultModel<List<CountriesRegions>> getProvinceCity(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin","*");
        ResultModel<List<CountriesRegions>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(provinceCityService.getProvinceCity());
        return resultModel;
    }


    @RequestMapping(value = "/getProvinceCityByCodes/{codes}", method = RequestMethod.GET)
    public ResultModel<List<AreaCode>> getUserByToken(@PathVariable(value = "codes")String codes) {
            ResultModel<List<AreaCode>> resultModel = new ResultModel<>();
            if (StringUtil.isEmpty(codes)){
                resultModel.setErrorDesc("no codes");
                resultModel.setSuccessed(false);
                return resultModel;
            }
            resultModel.setReturnValue(provinceCityService.getAreaList(codes));
            return resultModel;
    }
}
