package com.bxm.datapark.service.count;

import com.bxm.datapark.constant.Constant;
import com.bxm.datapark.dal.model.CountAwradmsgDetail;
import com.bxm.datapark.dal.model.CountTicketAdvertiser;
import com.bxm.datapark.dal.model.ext.MqResult;
import com.bxm.datapark.service.configure.Configuration;
import com.bxm.datapark.service.service.CountDataHubService;
import com.bxm.datapark.service.service.CountService;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * <h3>Count message listener for DataHub.</h3>
 *
 * @author allen
 * @since 1.0.0
 */
@Component
@EnableConfigurationProperties({AlionsPropsConfiguration.class, Configuration.class})
public class CountDataHubMessageListener extends AbstractCountMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(CountDataHubMessageListener.class);
    @Autowired
    private AlionsPropsConfiguration alionsCfg;
    @Autowired
    private Configuration localCfg;
    @Autowired
    private CountDataHubService countDataHubService;

    @Override
    public String getTopic() {
        return localCfg.getTopicUserAction();
    }

    @Override
    protected CountService getCountService() {
        return countDataHubService;
    }

    @Bean(initMethod = "init", destroyMethod = "destroy")
    public AlionsConsumer countDatahubConsumer() {
        return new AlionsConsumer(localCfg.getCountConsumerIdForDatahub(), alionsCfg.getConfig(), this);
    }
}
