package com.bxm.datapark.service.count;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.constant.Constant;
import com.bxm.datapark.dal.mapper.CountAwradmsgDetailMapper;
import com.bxm.datapark.dal.mapper.CountTicketAdvertiserMapper;
import com.bxm.datapark.dal.model.ext.MqResult;
import com.bxm.datapark.service.configure.Configuration;
import com.bxm.datapark.service.util.CountAdvertiserMaxCompute;
import com.bxm.datapark.service.util.CountAwardMaxCompute;
import com.bxm.datapark.service.util.WarnMsgUtils;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.MessageListener;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.List;
/**
 * @author allen
 * @date 2017-11-29
 */
@Component
@EnableConfigurationProperties({AlionsConfiguration.class, Configuration.class})
public class CountMessageListener implements MessageListener {

    @Autowired(
            required = false
    )
    private AlionsPropsConfiguration configuration;

    @Autowired
    private Configuration localCfg;

    @Autowired(required = false)
    private CountAwradmsgDetailMapper countAwradmsgDetailMapper;

    @Autowired(required = false)
    private CountTicketAdvertiserMapper countTicketAdvertiserMapper;

    @Autowired
    private CountAwardMaxCompute countAwardMaxCompute;

    @Autowired
    private CountAdvertiserMaxCompute countAdvertiserMaxCompute;

    private static final Logger log = LoggerFactory.getLogger(CountMessageListener.class);

    @Override
    public String getTopic() {
        return localCfg.getTopicUserAction();
    }

    @Override
    public ConsumeStatus consume(List<Message> messages, Object context) {
        try {
            Message message = messages.get(0);
            //more than 3 times message consuming will be ignored
            if(message != null && message.getReconsumeTimes() >= Constant.MAX_RETRY_TIMES) {
                WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken,"message has retried more than 3 times, it will be ignored",false,null);
                return ConsumeStatus.CONSUME_SUCCESS;
            }

            for (Message msg : messages) {
                byte[] body = msg.getBody();
                MqResult mqResult = JSON.parseObject(body,MqResult.class);
                if (mqResult.getCode() == 1){
                    countAwradmsgDetailMapper.insertSelective(mqResult.getCountAwardmsg());
                }else {
                    if (mqResult.getCountCertifiateAdshop().getShotToken() != null && mqResult.getCountCertifiateAdshop().getShotToken().length() > 32){
                        mqResult.getCountCertifiateAdshop().setShotToken("wrong_token");
                    }
                    countTicketAdvertiserMapper.insertSelective(mqResult.getCountCertifiateAdshop());
                }
            }
        } catch (Exception e) {
            if(e instanceof DuplicateKeyException) {
                log.info("duplicated key found: " + e.getMessage());
                return ConsumeStatus.CONSUME_SUCCESS;
            }

            log.error("count message consuming failed", e);
            return ConsumeStatus.RECONSUME_LATER;
        }

        return ConsumeStatus.CONSUME_SUCCESS;
    }

    @Bean
    public Consumer countConsumer() {
        return new AlionsConsumer(localCfg.getCountConsumerIdForDefault(), configuration.getConfig(),this) {

            @PostConstruct
            @Override
            protected void doInit() {
                super.doInit();
            }

            @PreDestroy
            @Override
            protected void doDestroy() {
                super.doDestroy();
            }
        };
    }
}
