/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.datapark.service.count;

import com.bxm.datapark.service.configure.Configuration;
import com.bxm.datapark.service.service.CountMongoService;
import com.bxm.datapark.service.service.CountService;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * @author allen
 * @since 1.0.0
 */
@Component
@EnableConfigurationProperties({AlionsPropsConfiguration.class, Configuration.class})
public class CountMongoMessageListener extends AbstractCountMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(CountMongoMessageListener.class);

    @Autowired
    private AlionsPropsConfiguration cfg;
    @Autowired
    private Configuration localCfg;
    @Autowired
    private CountMongoService countMongoService;

    @Override
    public String getTopic() {
        return localCfg.getTopicUserAction();
    }

    @Override
    protected CountService getCountService() {
        return countMongoService;
    }

    @Bean(initMethod = "init", destroyMethod = "destroy")
    public AlionsConsumer countMongoConsumer() {
        return new AlionsConsumer(localCfg.getCountConsumerIdForMongodb(), cfg.getConfig(), this);
    }
}
