package com.bxm.datapark.service.rpt.ad;

import com.bxm.datapark.service.service.MongoCashService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MongoCashController {

    @Autowired
    private MongoCashService mongoCashService;

    /**
     * 通过时间和礼券ID更新礼券集合收益信息
     * @param mapCertificate 礼券收益集合
     * @param mapBusiness 渠道收益集合
     * @param mapApp 媒体收益集合
     * @param datetime 时间
     */
    @PutMapping("/updateMongoMsg")
    public void updateMongoMsg(String mapCertificate,
                               String mapApp,
                               String mapBusiness,
                               String datetime,
                               String certificateidList) {
        mongoCashService.updateMongoMsg(mapCertificate,mapApp,mapBusiness,datetime,certificateidList);
    }

}
