package com.bxm.datapark.service.rpt.ad;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.dao.*;
import com.bxm.datapark.dal.mongo.ro.CommonRo;
import com.bxm.datapark.dal.mongo.vo.TicketCount;
import com.bxm.datapark.dal.mongo.vo.TicketCountApp;
import com.bxm.datapark.dal.mongo.vo.TicketCountBusiness;
import com.bxm.datapark.dal.mongo.vo.TicketCountHour;
import com.bxm.datapark.service.service.TicketCountHourService;
import com.bxm.datapark.service.service.TicketService;
import com.bxm.datapark.service.util.MongoSomeUtils;
import com.bxm.datapark.service.util.WarnMsgUtils;
import com.bxm.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.bxm.datapark.service.util.WarnMsgUtils.DDJobUrl;

/**
 * 备用方案
 *
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.service.mongo.mongo.TestController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-05 11:49:00
 * @modifier 董朱旭
 * @updated 2018-01-05 11:49:00
 */
@RestController
public class SpareController {
    /**
     * Logger for this class
     */
    private static final Logger LOGGER = Logger.getLogger(SpareController.class);


    /**
     * 服务层自动注入
     */
    @Autowired
    private TicketCountHourService ticketCountHourService;


    @Autowired
    private TicketService ticketService;

    private static final String DDJobUrl = "https://oapi.dingtalk.com/robot/send?access_token=";

    /**
     * 礼券定时任务
     *
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     * @param datetime
     * @return void
     */
    @GetMapping("/spare/certificate")
    public void spareCertificate(@RequestParam(name = "datetime") String datetime){
        try {
            if("2018-01-13".equals(datetime)){
                WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "原始数据丢失，不进行操作 -----------", false, null);
                return;
            }
            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken,"广告券报表汇总开始，存储时间【日期："+datetime+"】 -----------", false, null);
            Long start=System.currentTimeMillis();
            ticketService.ticketTask(datetime);
            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "广告券报表汇总结,，储时间【日期："+datetime+"】，用时："+((System.currentTimeMillis()-start)/1000)+"秒 -----------", false, null);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(),e);
            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "广告券报表汇总失败，存储时间【日期："+datetime+"】 -----------"+e, false, null);
        }
    }

    /**
     * 礼券按时
     *
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     * @param datetime
     * @param hour
     * @return void
     */
    @GetMapping("/spare/certificate/hour")
    public void spareCertificateForHour(@RequestParam(name = "datetime") String datetime,@RequestParam(name = "hour",required = false) Integer hour){
        try {
            if("2018-01-13".equals(datetime)){
               WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "原始数据丢失，不进行操作 -----------", false, null);
                return;
            }
            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "广告券报表按小时汇总开始，存储时间【日期："+datetime+(hour==null?"，时段：全天":"，时段："+hour)+"】 -----------", false, null);
            Long start=System.currentTimeMillis();
            if(hour!=null&& StringUtil.isNotEmpty(hour.toString())) {
                ticketCountHourService.task(datetime, hour);
            }else{
                for(int pox=MongoConstant.ZERO;pox<= MongoConstant.TWENTY_THREE;pox++){
                    ticketCountHourService.task(datetime, pox);
                }
            }

            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "广告券报表按小时汇总结束，存储时间【日期："+datetime+(hour==null?"，时段：全天":"，时段："+hour)+"】，用时："+((System.currentTimeMillis()-start)/1000)+"秒 -----------", false, null);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(),e);
            WarnMsgUtils.sendDdMsg(WarnMsgUtils.DDJobUrl+WarnMsgUtils.warnDingDingToken, "广告券报表按小时汇总失败，存储时间【日期："+datetime+(hour==null?"，时段：全天":"，时段："+hour)+"】-----------"+e, false, null);
        }
    }

}
