package com.bxm.datapark.service.rpt.ad;

import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.base.Page;
import com.bxm.datapark.dal.mongo.vo.TicketCount;
import com.bxm.datapark.dal.mongo.vo.TicketCountApp;
import com.bxm.datapark.dal.mongo.vo.TicketCountBusiness;
import com.bxm.datapark.service.service.TicketService;
import com.bxm.util.dto.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 广告券日报API
 *
 * @author zhangkai
 * @create 2018-01-10 10:25
 **/
@RestController
public class TicketCountController {

    @Autowired
    private TicketService ticketService;



    /*
     *  获取广告券日报（礼券维度）
     * @author zhangkai
     * @date 2018/1/10 11:00
     * @param
     * @return
     */
    @GetMapping("/ticket/ticketCertificate")
    public ResultModel<Page<TicketCount>> ticketCertificate(
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.CERTIFICATEID ,required = false) String certificateid,
            @RequestParam(name = MongoConstant.PAGE_SIZE, defaultValue = MongoConstant.TEN_S) Integer pageSize,
            @RequestParam(name = MongoConstant.PAGE_NUM, defaultValue = MongoConstant.ONE_S) Integer pageNum,
            @RequestParam(name = MongoConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = MongoConstant.SORT_TYPE, defaultValue = MongoConstant.SORT_TYPE_DESC) String sortType){

        ResultModel<Page<TicketCount>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketCount(datetime,certificateid,sortName,pageNum,pageSize,sortType));
        return resultModel;
    }



    /*
    *  获取广告券APP日报（开发者维度）
    * @author zhangkai
    * @date 2018/1/10 11:00
    * @param
    * @return
    */
    @GetMapping("/ticket/ticketApp")
    public ResultModel<Page<TicketCountApp>> ticketApp(
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.CERTIFICATEID) String certificateid,
            @RequestParam(name = MongoConstant.APPKEY_VO ,required = false) String appKey,
            @RequestParam(name = MongoConstant.PAGE_SIZE, defaultValue = MongoConstant.TEN_S) Integer pageSize,
            @RequestParam(name = MongoConstant.PAGE_NUM, defaultValue = MongoConstant.ONE_S) Integer pageNum,
            @RequestParam(name = MongoConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = MongoConstant.SORT_TYPE, defaultValue = MongoConstant.SORT_TYPE_DESC) String sortType){

        ResultModel<Page<TicketCountApp>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketCountApp(datetime,certificateid,appKey,sortName,sortType,pageNum,pageSize));
        return resultModel;
    }


    /*
    *  获取广告券BUSINESS日报（渠道维度）
    * @author zhangkai
    * @date 2018/1/10 11:00
    * @param
    * @return
    */
    @GetMapping("/ticket/ticketBusiness")
    public ResultModel<Page<TicketCountBusiness>> ticketBusiness(
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.CERTIFICATEID) String certificateid,
            @RequestParam(name = MongoConstant.APPKEY_VO ,required = false) String appKey,
            @RequestParam(name = MongoConstant.BUSINESS ,required = false) String business,
            @RequestParam(name = MongoConstant.PAGE_SIZE, defaultValue = MongoConstant.TEN_S) Integer pageSize,
            @RequestParam(name = MongoConstant.PAGE_NUM, defaultValue = MongoConstant.ONE_S) Integer pageNum,
            @RequestParam(name = MongoConstant.SORT_NAME, defaultValue = "openPv") String sortName,
            @RequestParam(name = MongoConstant.SORT_TYPE, defaultValue = MongoConstant.SORT_TYPE_DESC) String sortType){

        ResultModel<Page<TicketCountBusiness>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketCountBusiness(datetime,certificateid,appKey,business,sortName,sortType,pageNum,pageSize));
        return resultModel;
    }


    /*
    *  获取广告券日报（按日维度）
    * @author zhangkai
    * @date 2018/1/10 11:00
    * @param
    * @return
    */
    @GetMapping("/ticket/ticketByDatetime")
    public ResultModel<List<TicketCount>> ticketByDatetime(
            @RequestParam(name = "startTime") String startTime,
            @RequestParam(name = "endTime") String endTime,
            @RequestParam(name = MongoConstant.CERTIFICATEID) String certificateid){

        ResultModel<List<TicketCount>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketByDatetime(startTime,endTime,certificateid));
        return resultModel;
    }


    /*
     *  获取广告券日报（礼券维度）
     * @author zhangkai
     * @date 2018/1/10 11:00
     * @param
     * @return
     */
    @GetMapping("/ticket/ticketCertificate/export")
    public ResultModel<List<TicketCount>> ticketCertificateExport(
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.CERTIFICATEID ,required = false) String certificateid){

        ResultModel<List<TicketCount>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketCount(datetime,certificateid));
        return resultModel;
    }



    /*
     *  获取广告券APP日报（开发者维度）
     * @author zhangkai
     * @date 2018/1/10 11:00
     * @param
     * @return
     */
    @GetMapping("/ticket/ticketApp/export")
    public ResultModel<List<TicketCountApp>> ticketAppExport(
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.CERTIFICATEID) String certificateid,
            @RequestParam(name = MongoConstant.APPKEY_VO ,required = false) String appKey){

        ResultModel<List<TicketCountApp>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketCountApp(datetime,certificateid,appKey));
        return resultModel;
    }


    /*
     *  获取广告券BUSINESS日报（渠道维度）
     * @author zhangkai
     * @date 2018/1/10 11:00
     * @param
     * @return
     */
    @GetMapping("/ticket/ticketBusiness/export")
    public ResultModel<List<TicketCountBusiness>> ticketBusinessExport(
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.CERTIFICATEID) String certificateid,
            @RequestParam(name = MongoConstant.APPKEY_VO ,required = false) String appKey,
            @RequestParam(name = MongoConstant.BUSINESS ,required = false) String business){

        ResultModel<List<TicketCountBusiness>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketCountBusiness(datetime,certificateid,appKey,business));
        return resultModel;
    }


    /*
     *  获取广告券日报（按日维度）
     * @author zhangkai
     * @date 2018/1/10 11:00
     * @param
     * @return
     */
    @GetMapping("/ticket/ticketByDatetime/export")
    public ResultModel<List<TicketCount>> ticketByDatetimeExport(
            @RequestParam(name = "startTime") String startTime,
            @RequestParam(name = "endTime") String endTime,
            @RequestParam(name = MongoConstant.CERTIFICATEID) String certificateid){

        ResultModel<List<TicketCount>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(ticketService.findTicketByDatetime(startTime,endTime,certificateid));
        return resultModel;
    }

}
