package com.bxm.datapark.service.rpt.ad;

import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.base.Page;
import com.bxm.datapark.dal.mongo.ro.TicketCountHourRo;
import com.bxm.datapark.dal.mongo.vo.TicketCountHour;
import com.bxm.datapark.service.service.TicketCountHourService;
import com.bxm.util.dto.ResultModel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 广告券报表按小时查询
 *
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.service.rpt.ad.TicketCountHourController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-10 09:44:00
 * @modifier 董朱旭
 * @updated 2018-01-10 09:44:00
 */
@RestController
public class TicketCountHourController {

    /**
     * Logger for this class
     */
    private static final Logger LOGGER = Logger.getLogger(TicketCountHourController.class);

    @Autowired
    private TicketCountHourService ticketCountHourService;

    /**
     * 查询广告券按小时
     *
     * @param certificateid 礼券 ID
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @param pageSize 当前页面大小
     * @param pageNum 当前页码
     * @param sortName 排序字段
     * @param sortType 排序方式
     * @return com.bxm.util.dto.ResultModel<com.bxm.datapark.dal.mongo.base.Page   <   com.bxm.datapark.dal.mongo.vo.TicketCountHour>>
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     */
    @GetMapping("/certificate/hour")
    public ResultModel<Page<TicketCountHourRo>> findCountForCertificate(
            @RequestParam(name = MongoConstant.CERTIFICATEID, required = false) Long certificateid,
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.S_HOUR, required = false, defaultValue = MongoConstant.ZERO_S) Integer sHour,
            @RequestParam(name = MongoConstant.E_HOUR, required = false, defaultValue = MongoConstant.FIVE_S) Integer eHour,
            @RequestParam(name = MongoConstant.PAGE_SIZE, required = false, defaultValue = MongoConstant.TEN_S) Integer pageSize,
            @RequestParam(name = MongoConstant.PAGE_NUM, required = false, defaultValue = MongoConstant.ONE_S) Integer pageNum,
            @RequestParam(name = MongoConstant.SORT_NAME, required = false, defaultValue = MongoConstant.DEFAULT_SORT_NAME) String sortName,
            @RequestParam(name = MongoConstant.SORT_TYPE, required = false, defaultValue = MongoConstant.SORT_TYPE_ASC) String sortType) {

        //声明结果集
        ResultModel<Page<TicketCountHourRo>> rs=new ResultModel<Page<TicketCountHourRo>>();
        try {
            //服务层调用
            rs.setReturnValue(ticketCountHourService.findCountForHour(certificateid,null,null,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常情况
            rs.setSuccessed(false);
            rs.setErrorDesc("system error!");
            LOGGER.error(e.getMessage(),e);
        }
        //返回结果
        return rs;
    }
    /**
     * 查询广告券报表，开发者维度按小时
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param certificateid 礼券 ID
     * @param appkey 开发者标志
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @param pageSize 当前页面大小
     * @param pageNum 当前页码
     * @param sortName 排序字段
     * @param sortType 排序方式
     * @return com.bxm.util.dto.ResultModel<com.bxm.datapark.dal.mongo.base.Page<com.bxm.datapark.dal.mongo.vo.TicketCountHour>>
     */
    @GetMapping("/certificate/app/hour")
    public ResultModel<Page<TicketCountHourRo>> findCountForApp(
            @RequestParam(name = MongoConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = MongoConstant.APPKEY) String appkey,
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.S_HOUR, required = false, defaultValue = MongoConstant.ZERO_S) Integer sHour,
            @RequestParam(name = MongoConstant.E_HOUR, required = false, defaultValue = MongoConstant.FIVE_S) Integer eHour,
            @RequestParam(name = MongoConstant.PAGE_SIZE, required = false, defaultValue = MongoConstant.TEN_S) Integer pageSize,
            @RequestParam(name = MongoConstant.PAGE_NUM, required = false, defaultValue = MongoConstant.ONE_S) Integer pageNum,
            @RequestParam(name = MongoConstant.SORT_NAME, required = false, defaultValue = MongoConstant.DEFAULT_SORT_NAME) String sortName,
            @RequestParam(name = MongoConstant.SORT_TYPE, required = false, defaultValue = MongoConstant.SORT_TYPE_ASC) String sortType) {

        //声明结果集
        ResultModel<Page<TicketCountHourRo>> rs=new ResultModel<Page<TicketCountHourRo>>();
        try {
            //服务层调用
            rs.setReturnValue(ticketCountHourService.findCountForHour(certificateid,appkey,null,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常情况
            rs.setSuccessed(false);
            rs.setErrorDesc("system error!");
            LOGGER.error(e.getMessage(),e);
        }
        //返回结果
        return rs;
    }
    /**
     * 广告券报表子链接维度按小时
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param certificateid 礼券 ID
     * @param appkey 开发者标志
     * @param business 子渠道标志
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @param pageSize 当前页面大小
     * @param pageNum 当前页码
     * @param sortName 排序字段
     * @param sortType 排序方式
     * @return com.bxm.util.dto.ResultModel<com.bxm.datapark.dal.mongo.base.Page<com.bxm.datapark.dal.mongo.vo.TicketCountHour>>
     */
    @GetMapping("/certificate/business/hour")
    public ResultModel<Page<TicketCountHourRo>> findCountFoBusiness(
            @RequestParam(name = MongoConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = MongoConstant.APPKEY) String appkey,
            @RequestParam(name = MongoConstant.BUSINESS) String business,
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.S_HOUR, required = false, defaultValue = MongoConstant.ZERO_S) Integer sHour,
            @RequestParam(name = MongoConstant.E_HOUR, required = false, defaultValue = MongoConstant.FIVE_S) Integer eHour,
            @RequestParam(name = MongoConstant.PAGE_SIZE, required = false, defaultValue = MongoConstant.TEN_S) Integer pageSize,
            @RequestParam(name = MongoConstant.PAGE_NUM, required = false, defaultValue = MongoConstant.ONE_S) Integer pageNum,
            @RequestParam(name = MongoConstant.SORT_NAME, required = false, defaultValue = MongoConstant.DEFAULT_SORT_NAME) String sortName,
            @RequestParam(name = MongoConstant.SORT_TYPE, required = false, defaultValue = MongoConstant.SORT_TYPE_ASC) String sortType) {

        //声明结果集
        ResultModel<Page<TicketCountHourRo>> rs=new ResultModel<Page<TicketCountHourRo>>();
        try {
            if(business.indexOf(MongoConstant.AD_PARAME)==MongoConstant.BAR_ONE){
                business=MongoConstant.AD_PARAME_BAR+business;
            }
            //服务层调用
            rs.setReturnValue(ticketCountHourService.findCountForHour(certificateid,appkey,business,datetime,sHour,eHour,pageSize,pageNum,sortName,sortType));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常情况
            rs.setSuccessed(false);
            rs.setErrorDesc("system error!");
            LOGGER.error(e.getMessage(),e);
        }
        //返回结果
        return rs;
    }



    /**
     * 导出查询广告券按小时
     *
     * @param certificateid 礼券 ID
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @return com.bxm.util.dto.ResultModel<com.bxm.datapark.dal.mongo.base.Page   <   com.bxm.datapark.dal.mongo.vo.TicketCountHour>>
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     */
    @GetMapping("/certificate/hour/export")
    public ResultModel<List<TicketCountHourRo>> findCountForCertificateExport(
            @RequestParam(name = MongoConstant.CERTIFICATEID, required = false) Long certificateid,
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.S_HOUR, required = false, defaultValue = MongoConstant.ZERO_S) Integer sHour,
            @RequestParam(name = MongoConstant.E_HOUR, required = false, defaultValue = MongoConstant.FIVE_S) Integer eHour) {

        //声明结果集
        ResultModel<List<TicketCountHourRo>> rs=new ResultModel<List<TicketCountHourRo>>();
        try {
            //服务层调用
            rs.setReturnValue(ticketCountHourService.findCountForHour(certificateid,null,null,datetime,sHour,eHour));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常情况
            rs.setSuccessed(false);
            rs.setErrorDesc("system error!");
            LOGGER.error(e.getMessage(),e);
        }
        //返回结果
        return rs;
    }
    /**
     * 查询广告券报表，开发者维度按小时
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param certificateid 礼券 ID
     * @param appkey 开发者标志
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @return com.bxm.util.dto.ResultModel<com.bxm.datapark.dal.mongo.base.Page<com.bxm.datapark.dal.mongo.vo.TicketCountHour>>
     */
    @GetMapping("/certificate/app/hour/export")
    public ResultModel<List<TicketCountHourRo>> findCountForAppExport(
            @RequestParam(name = MongoConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = MongoConstant.APPKEY) String appkey,
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.S_HOUR, required = false, defaultValue = MongoConstant.ZERO_S) Integer sHour,
            @RequestParam(name = MongoConstant.E_HOUR, required = false, defaultValue = MongoConstant.FIVE_S) Integer eHour) {

        //声明结果集
        ResultModel<List<TicketCountHourRo>> rs=new ResultModel<List<TicketCountHourRo>>();
        try {
            //服务层调用
            rs.setReturnValue(ticketCountHourService.findCountForHour(certificateid,appkey,null,datetime,sHour,eHour));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常情况
            rs.setSuccessed(false);
            rs.setErrorDesc("system error!");
            LOGGER.error(e.getMessage(),e);
        }
        //返回结果
        return rs;
    }
    /**
     * 广告券报表子链接维度按小时
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param certificateid 礼券 ID
     * @param appkey 开发者标志
     * @param business 子渠道标志
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @return com.bxm.util.dto.ResultModel<com.bxm.datapark.dal.mongo.base.Page<com.bxm.datapark.dal.mongo.vo.TicketCountHour>>
     */
    @GetMapping("/certificate/business/hour/export")
    public ResultModel<List<TicketCountHourRo>> findCountFoBusinessExport(
            @RequestParam(name = MongoConstant.CERTIFICATEID) Long certificateid,
            @RequestParam(name = MongoConstant.APPKEY) String appkey,
            @RequestParam(name = MongoConstant.BUSINESS) String business,
            @RequestParam(name = MongoConstant.DATETIME) String datetime,
            @RequestParam(name = MongoConstant.S_HOUR, required = false, defaultValue = MongoConstant.ZERO_S) Integer sHour,
            @RequestParam(name = MongoConstant.E_HOUR, required = false, defaultValue = MongoConstant.FIVE_S) Integer eHour) {

        //声明结果集
        ResultModel<List<TicketCountHourRo>> rs=new ResultModel<List<TicketCountHourRo>>();
        try {
            if(business.indexOf(MongoConstant.AD_PARAME)==MongoConstant.BAR_ONE){
                business=MongoConstant.AD_PARAME_BAR+business;
            }
            //服务层调用
            rs.setReturnValue(ticketCountHourService.findCountForHour(certificateid,appkey,business,datetime,sHour,eHour));
            rs.setSuccessed(true);
        } catch (Exception e) {
            //异常情况
            rs.setSuccessed(false);
            rs.setErrorDesc("system error!");
            LOGGER.error(e.getMessage(),e);
        }
        //返回结果
        return rs;
    }
}
