package com.bxm.datapark.service.service;

import com.aliyun.datahub.model.RecordEntry;
import com.bxm.datapark.dal.model.CountAwradmsgDetail;
import com.bxm.datapark.dal.model.CountTicketAdvertiser;
import com.bxm.datapark.service.conf.DataCollectorManager;
import com.bxm.datapark.service.util.CountAdvertiserDataHub;
import com.bxm.datapark.service.util.CountAwardDataHub;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author allen
 * @since 1.0.0
 */
@Service
public class CountDataHubService implements CountService {

    @Autowired
    private DataCollectorManager dataCollectorManager;

    @Autowired
    private CountAwardDataHub countAwardDataHub;

    @Autowired
    private CountAdvertiserDataHub countAdvertiserDataHub;

    @Override
    public void save(String msgId, CountAwradmsgDetail o) {
        if (null == o)
            return;
        RecordEntry record = dataCollectorManager.createRecord(DataCollectorManager.TOPIC.USER_BEHAVIOR);
        record = countAwardDataHub.insertEntrty(o, msgId, record);
        dataCollectorManager.sendRecords(DataCollectorManager.TOPIC.USER_BEHAVIOR, record);
    }

    @Override
    public void save(String msgId, CountTicketAdvertiser o) {
        if (null == o)
            return;
        RecordEntry record = dataCollectorManager.createRecord(DataCollectorManager.TOPIC.AD_HIT);
        record =  countAdvertiserDataHub.insertEntrty(o, msgId, record);
        dataCollectorManager.sendRecords(DataCollectorManager.TOPIC.AD_HIT, record);
    }
}
