/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.datapark.service.service;

import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.model.CountAwradmsgDetail;
import com.bxm.datapark.dal.model.CountTicketAdvertiser;
import com.mongodb.DBCollection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/**
 * <h3>Count service for mongodb</h3>
 *
 * @author allen
 * @since 1.0.0
 */
@Service
public class CountMongoService implements CountService {

    private final MongoTemplate template;

    @Autowired
    private MongoMappingContext mappingContext;

    @Autowired
    public CountMongoService(MongoTemplate template) {
        this.template = template;
    }


    @Scheduled(initialDelay = 1000, fixedDelay = 24 * 60 * 60 * 1000)
    public void schedule() {
        // 这个操作主要是创建次日的collection，因为通过按自定义collectionName来创建的collection无法自动创建索引。
        createIndexes(CountAwradmsgDetail.class, CountAwradmsgDetail.getCollectionNameOfDay(1));
//        createIndexes(CountTicketAdvertiser.class, CountTicketAdvertiser.getCollectionNameOfDay(1));
    }

    private void createIndexes(Class<?> cls, String collectionName) {
        DBCollection collection = null;
        if (!template.collectionExists(collectionName)) {
            collection = template.createCollection(collectionName);
        } else {
            collection = template.getCollection(collectionName);
        }

        MongoPersistentEntityIndexResolver indexResolver = new MongoPersistentEntityIndexResolver(mappingContext);
        Iterable<? extends MongoPersistentEntityIndexResolver.IndexDefinitionHolder> indexes = indexResolver.resolveIndexFor(ClassTypeInformation.from(cls));
        for (MongoPersistentEntityIndexResolver.IndexDefinitionHolder index : indexes) {
            collection.createIndex(index.getIndexKeys());
        }
    }

    @Override
    public void save(String msgId, CountAwradmsgDetail o) {
        if (null == o) {
            return;
        }
        template.insert(o, CountAwradmsgDetail.getCollectionNameOfDay());
    }

    @Override
    public void save(String msgId, CountTicketAdvertiser o) {
        if (null == o) {
            return;
        }
        if (!StringUtils.equals(String.valueOf(MongoConstant.CLICK_PV), o.getModeltype())) {
            return;
        }
        Query query = Query.query(Criteria.where("countid").is(o.getShotCountid()));
        String collectionName = CountAwradmsgDetail.getCollectionNameOfDay();
        Update update = new Update().set("vaild", 1);
        template.upsert(query, update, collectionName);
    }
}
