package com.bxm.datapark.service.service;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.dao.TicketCountAppDao;
import com.bxm.datapark.dal.mongo.dao.TicketCountBusinessDao;
import com.bxm.datapark.dal.mongo.dao.TicketCountDao;
import com.bxm.datapark.dal.mongo.vo.TicketCount;
import com.bxm.datapark.dal.mongo.vo.TicketCountApp;
import com.bxm.datapark.dal.mongo.vo.TicketCountBusiness;
import com.bxm.datapark.service.util.MongoSomeUtils;
import com.bxm.util.StringUtil;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class MongoCashService {
    /**
     * Logger for this class
     */
    private static final Logger LOGGER = Logger.getLogger(MongoCashService.class);
    @Autowired
    private TicketCountDao ticketCountDao;

    @Autowired
    private TicketCountAppDao ticketCountAppDao;

    @Autowired
    private TicketCountBusinessDao ticketCountBusinessDao;


    /**
     * 更新收益
     *
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param mapCertificate
     * @param mapApp
     * @param mapBusiness
     * @param datetime
     * @param certificateidList
     * @return void
     */
    public void updateMongoMsg(String mapCertificate, String mapApp, String mapBusiness, String datetime, String certificateidList) {
        try {
            //礼券 ID 集合等信息为 null
            if(StringUtil.isEmpty(mapCertificate)||StringUtil.isEmpty(mapApp)||StringUtil.isEmpty(mapBusiness)||StringUtil.isEmpty(datetime)||StringUtil.isEmpty(certificateidList)){
                return;
            }
            //礼券 ID
            List<Long> certificateids= JSON.parseArray(certificateidList,Long.class);
            //声明查询条件
            Query query=new Query();
            query.addCriteria(Criteria.where(MongoConstant.DATETIME).is(datetime).and(MongoConstant.CERTIFICATEID).in(certificateids));

            //礼券收益
            Map<String,BigDecimal> mapCertificateCash= (Map)JSONObject.fromObject(mapCertificate);
            dealCertificateCash(mapCertificateCash,datetime,query);

            //礼券收益
            Map<String,BigDecimal> mapAppCash= (Map) JSONObject.fromObject(mapApp);
            dealAppCash(mapAppCash,datetime,query);

            //礼券收益
            Map<String,BigDecimal> mapBusinessCash= (Map)JSONObject.fromObject(mapBusiness);
            dealBusinessCash(mapBusinessCash,datetime,query);
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage(),e);
        }
    }
    /**
     * 处理子渠道收益
     *
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param mapBusinessCash
     * @param datetime
     * @param query
     * @return void
     */
    private void dealBusinessCash(Map<String, BigDecimal> mapBusinessCash, String datetime,Query query) {
        //集合名称
        String collectionName=MongoSomeUtils.getBusinessCollectionName(datetime);
        //按子渠道分组查询信息
        List<TicketCountBusiness> list=ticketCountBusinessDao.find(query, collectionName);
        //昨天数据查询
        List<TicketCountBusiness> listPre=ticketCountBusinessDao.find(query, MongoSomeUtils.getBusinessCollectionName(MongoSomeUtils.getPreDate(datetime)));
        //存储到map
        Map<String,TicketCountBusiness> mapPre=new HashMap<>(CollectionUtils.isNotEmpty(listPre)?listPre.size():MongoConstant.ZERO);
        //若存在存昨日数据储到map
        if(CollectionUtils.isNotEmpty(listPre)){
            listPre.stream().forEach(preData->mapPre.put(MongoSomeUtils.concat(MongoSomeUtils.concat(preData.getCertificateid().toString(),preData.getAppKey()),preData.getBusiness()),preData));
        }
        //遍历更新
        list.stream().forEach(ticketCountBusiness -> {
            //礼券ID
            Long certificateid=ticketCountBusiness.getCertificateid();
            //appkey
            String appkey=ticketCountBusiness.getAppKey();
            //子渠道标志
            String business=ticketCountBusiness.getBusiness();
            //收益获取
            BigDecimal cash=mapBusinessCash.get(MongoSomeUtils.concat(MongoSomeUtils.concat(certificateid.toString(),appkey),business));
            //获取昨天数据
            TicketCountBusiness ticketCountBusinessPre = mapPre.get(MongoSomeUtils.concat(MongoSomeUtils.concat(certificateid.toString(),appkey),business));
            //更新条件
            Query queryUpdate=new Query(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).and(MongoConstant.APPKEY_VO).is(appkey).and(MongoConstant.BUSINESS).is(business));
            if(ticketCountBusinessPre!=null){
                //更新子渠道收益信息
                ticketCountBusinessDao.update(queryUpdate,getUpdate(cash,ticketCountBusiness.getOpenPv(),ticketCountBusiness.getClickPv(),ticketCountBusinessPre.getIncome(),ticketCountBusinessPre.getOpenPvAurp(),ticketCountBusinessPre.getClickAurp()),collectionName);
            }else{
                //更新子渠道收益信息
                ticketCountBusinessDao.update(queryUpdate,getUpdate(cash,ticketCountBusiness.getOpenPv(),ticketCountBusiness.getClickPv(),null,null,null),collectionName);
            }
        });
    }

    /**
     * 处理开发者收益
     *
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param mapAppCash
     * @param datetime
     * @param query
     * @return void
     */
    private void dealAppCash(Map<String, BigDecimal> mapAppCash, String datetime,Query query) {

        //集合名称
        String collectionName=MongoSomeUtils.getAppCollectionName(datetime);
        //按开发者分组查询信息
        List<TicketCountApp> list=ticketCountAppDao.find(query, collectionName);
        //昨天数据查询
        List<TicketCountApp> listPre=ticketCountAppDao.find(query, MongoSomeUtils.getAppCollectionName(MongoSomeUtils.getPreDate(datetime)));
        //存储到map
        Map<String,TicketCountApp> mapPre=new HashMap<>(CollectionUtils.isNotEmpty(listPre)?listPre.size():MongoConstant.ZERO);
        //若存在存昨日数据储到map
        if(CollectionUtils.isNotEmpty(listPre)){
            listPre.stream().forEach(preData->mapPre.put(MongoSomeUtils.concat(preData.getCertificateid().toString(),preData.getAppKey()),preData));
        }
        //遍历更新
        list.stream().forEach(ticketCountApp -> {
            //礼券ID
            Long certificateid=ticketCountApp.getCertificateid();
            //appkey
            String appkey=ticketCountApp.getAppKey();
            //收益获取
            BigDecimal cash=mapAppCash.get(MongoSomeUtils.concat(certificateid.toString(),appkey));
            //获取昨天数据
            TicketCountApp ticketCountAppPre = mapPre.get(MongoSomeUtils.concat(certificateid.toString(),appkey));
            //更新条件
            Query queryUpdate=new Query(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).and(MongoConstant.APPKEY_VO).is(appkey));
            if(ticketCountAppPre!=null){
                //更新子渠道收益信息
                ticketCountAppDao.update(queryUpdate,getUpdate(cash,ticketCountApp.getOpenPv(),ticketCountApp.getClickPv(),ticketCountAppPre.getIncome(),ticketCountAppPre.getOpenPvAurp(),ticketCountAppPre.getClickAurp()),collectionName);
            }else{
                //更新子渠道收益信息
                ticketCountAppDao.update(queryUpdate,getUpdate(cash,ticketCountApp.getOpenPv(),ticketCountApp.getClickPv(),null,null,null),collectionName);
            }
        });
    }


    /**
     * 处理礼券维度的收益
     *
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param mapCertificateCash
     * @param datetime
     * @param query
     * @return void
     */
    private void dealCertificateCash(Map<String, BigDecimal> mapCertificateCash, String datetime, Query query) {

        //集合名称
        String collectionName=MongoSomeUtils.getCertificateCollectionName(datetime);
        //按礼券分组查询信息
        List<TicketCount> list=ticketCountDao.find(query, collectionName);
        //昨天数据查询
        List<TicketCount> listPre=ticketCountDao.find(query, MongoSomeUtils.getCertificateCollectionName(MongoSomeUtils.getPreDate(datetime)));
        //存储到map
        Map<String,TicketCount> mapPre=new HashMap<>(CollectionUtils.isNotEmpty(listPre)?listPre.size():MongoConstant.ZERO);
        //若存在存昨日数据储到map
        if(CollectionUtils.isNotEmpty(listPre)){
            listPre.stream().forEach(preData->mapPre.put(preData.getCertificateid().toString(),preData));
        }
        //遍历更新
        list.stream().forEach(ticketCount -> {
            //礼券ID
            Long certificateid=ticketCount.getCertificateid();
            //收益获取
            BigDecimal cash=mapCertificateCash.get(certificateid.toString());
            //昨日数据
            TicketCount ticketCountPre = mapPre.get(certificateid.toString());
            //更新条件
            Query queryUpdate=new Query(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid));
            if(ticketCountPre!=null){
                //更新子渠道收益信息
                ticketCountDao.update(queryUpdate,getUpdate(cash,ticketCount.getOpenPv(),ticketCount.getClickPv(),ticketCountPre.getIncome(),ticketCountPre.getOpenPvAurp(),ticketCountPre.getClickAurp()),collectionName);
            }else{
                //更新子渠道收益信息
                ticketCountDao.update(queryUpdate,getUpdate(cash,ticketCount.getOpenPv(),ticketCount.getClickPv(),null,null,null),collectionName);
            }

        });
    }
    /**
     * 处理需要更新的东西
     *
     * @author 董朱旭
     * @time 2018/1/16
     * @CopyRight 杭州微财网络科技有限公司
     * @param cash 当天收益
     * @param openPv 当天的额发全了
     * @param clickPv 当天的点击量
     * @param cashPre 昨日收益
     * @param openPvAurpPre 昨日发券aurp
     * @param clickPvAurpPre 昨日的点击aurp
     * @return org.springframework.data.mongodb.core.query.Update
     */
    private Update getUpdate(BigDecimal cash,Integer openPv,Integer clickPv,BigDecimal cashPre,BigDecimal openPvAurpPre,BigDecimal clickPvAurpPre){
        //更新条件封装
        Update u = new Update();

        //发券 aurp
        BigDecimal openPvAurp=MongoSomeUtils.getConversion(cash,openPv);
        //点击 ARUP
        BigDecimal clickPvAurp=MongoSomeUtils.getConversion(cash,clickPv);

        //收入处理
        u.set(MongoConstant.INCOME,cash);
        //发券 AURP
        u.set(MongoConstant.OPEN_PV_AURP,openPvAurp);
        //点击 ARUP
        u.set(MongoConstant.CLICK_AURP,clickPvAurp);

        //涨幅处理

        if(cashPre!=null){
            //券收入涨幅
            u.set(MongoConstant.INCOME_CHANGE,MongoSomeUtils.dealChange(cashPre,cash));
            //发券 arup 涨幅
            u.set(MongoConstant.OPEN_PV_AURP_CHANGE,MongoSomeUtils.dealChange( openPvAurpPre,openPvAurp));
            //点击 arup 涨幅
            u.set(MongoConstant.CLICK_AURP_CHANGE,MongoSomeUtils.dealChange(clickPvAurpPre,clickPvAurp));
        }else{
            //券收入涨幅
            u.set(MongoConstant.INCOME_CHANGE,"-");
            //发券 arup 涨幅
            u.set(MongoConstant.OPEN_PV_AURP_CHANGE,"-");
            //点击 arup 涨幅
            u.set(MongoConstant.CLICK_AURP_CHANGE,"-");
        }
        return u;
    }
}
