package com.bxm.datapark.service.service;

import com.bxm.datapark.dal.mapper.ext.ProvinceCityMapperExt;
import com.bxm.datapark.dal.model.ext.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *
 * @author zhangkai
 * @create 2017-12-12 15:34
 **/
@Service
public class ProvinceCityService {

    @Autowired
    private ProvinceCityMapperExt provinceCityMapperExt;

    public List<CountriesRegions> getProvinceCity(){
        List<CountriesRegions> countriesRegionss = new ArrayList<CountriesRegions>();
        List<String> regions  = provinceCityMapperExt.getRegion();
        //查询所有的大区
        for (String region : regions){
            CountriesRegions countriesRegions = new CountriesRegions();
            countriesRegions.setReginos(region);
            List<CountriesRegions.Province> provinces = new ArrayList<CountriesRegions.Province>();
            List<ProvinceEntity> provinceEntities = provinceCityMapperExt.getProvince(region) ;
            for (ProvinceEntity provinceEntity : provinceEntities){
                List<CountriesRegions.City> cities = new ArrayList<CountriesRegions.City>();
                CountriesRegions.Province province = countriesRegions. new Province();
                province.setProvinceCode(provinceEntity.getCode());
                province.setProvinceName(provinceEntity.getProvinceName());
                List<CityEntity> cityEntities = provinceCityMapperExt.getCity(provinceEntity.getProvince());
                for (CityEntity cityEntity : cityEntities){
                    CountriesRegions.City city = countriesRegions. new City();
                    city.setCityCode(cityEntity.getCityCode());
                    city.setCityName(cityEntity.getCityName());
                    List<CountriesRegions.County> countyList = new ArrayList<>();
                    List<CountyEntity> countyEntities = provinceCityMapperExt.getCounty(cityEntity.getCityType());
                    for (CountyEntity countyEntity : countyEntities){
                        CountriesRegions.County county = countriesRegions. new County();
                        county.setCountyCode(countyEntity.getCountyCode());
                        county.setCountyName(countyEntity.getCountyName());
                        countyList.add(county);
                    }
                    countyList.remove(0);
                    city.setCounties(countyList);
                    cities.add(city);
                }
                cities.remove(0);
                province.setCity(cities);
                provinces.add(province);
            }
            countriesRegions.setProvinces(provinces);
            countriesRegionss.add(countriesRegions);
        }

        return  countriesRegionss;
    }

    public List<AreaCode> getAreaList(String codes){
        return provinceCityMapperExt.getAreaByCodes(codes.split(","));
    }
}
