package com.bxm.datapark.service.service;

import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.base.Page;
import com.bxm.datapark.dal.mongo.dao.TicketCountHourDao;
import com.bxm.datapark.dal.mongo.ro.CommonRo;
import com.bxm.datapark.dal.mongo.ro.TicketCountHourRo;
import com.bxm.datapark.dal.mongo.vo.TicketCountHour;
import com.bxm.datapark.enums.SumType;
import com.bxm.datapark.service.util.MongoSomeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 按小时维度的
 *
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.service.service.TicketCountHourService.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-06 17:17:00
 * @modifier 董朱旭
 * @updated 2018-01-06 17:17:00
 * @description
 */
@Service
public class TicketCountHourService {

    /**
     * 数据访问层自动注入
     */
    @Autowired
    private TicketCountHourDao ticketCountHourDao;

    /**
     * 最原始的数据
     */
    @Autowired
    private AwardDetailService awardDetailService;

    /**
     * 按小时统计
     *
     * @param datetime
     * @param hour
     * @return void
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    public synchronized void task(String datetime, Integer hour) throws ParseException {
        //礼券维度
        dealCertificate(datetime, hour);
        //开发者维度
        dealApp(datetime, hour);
        //子渠道维度
        dealBusiness(datetime, hour);
    }

    /**
     * 以子渠道维度批量新增
     *
     * @param datetime
     * @param hour
     * @return void
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    private synchronized void dealBusiness(String datetime, Integer hour) throws ParseException {
        //获取集合名称
        String collectionName = MongoSomeUtils.getCountBusinessHourCollectionName(datetime);
        //条件
        Query query=new Query(Criteria.where(MongoConstant.HOUR).is(hour));
        //删除里面存在的历史记录
        ticketCountHourDao.remove(query, collectionName); //删除里面存在的历史记录
        //查询子渠道维度
        List<CommonRo> commonRos = awardDetailService.taskForBusiness(datetime, hour);
        //查询昨天的数据，计算涨幅
        List<TicketCountHour> preDatas = ticketCountHourDao.find(query,MongoSomeUtils.getCountBusinessHourCollectionName(MongoSomeUtils.getPreDate(datetime)));
        //声明存储map,减少遍历
        Map<String,TicketCountHour> mapPreData=new HashMap<String,TicketCountHour>(CollectionUtils.isNotEmpty(preDatas)?preDatas.size():MongoConstant.ZERO);
        //若存在存昨日数据储到map
        if(CollectionUtils.isNotEmpty(preDatas)){
            preDatas.stream().forEach(preData->mapPreData.put(MongoSomeUtils.concat(MongoSomeUtils.concat(preData.getCertificateid().toString(),preData.getAppKey()),preData.getBusiness()),preData));
        }
        //批量新增
        insertBach(commonRos, hour, collectionName,mapPreData, SumType.CERTIFICATE_APP_BUSINESS.getCode());
    }

    /**
     * 以开发者维度批量新增
     *
     * @param datetime
     * @param hour
     * @return void
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    private synchronized void dealApp(String datetime, Integer hour) throws ParseException {
        //获取集合名称
        String collectionName = MongoSomeUtils.getCountAppHourCollectionName(datetime);
        //条件
        Query query=new Query(Criteria.where(MongoConstant.HOUR).is(hour));
        //删除里面存在的历史记录
        ticketCountHourDao.remove(query, collectionName);
        //查询礼券维度
        List<CommonRo> commonRos = awardDetailService.taskForApp(datetime, hour);
        //查询昨天的数据，计算涨幅
        List<TicketCountHour> preDatas = ticketCountHourDao.find(query,MongoSomeUtils.getCountAppHourCollectionName(MongoSomeUtils.getPreDate(datetime)));
        //声明存储map,减少遍历
        Map<String,TicketCountHour> mapPreData=new HashMap<String,TicketCountHour>(CollectionUtils.isNotEmpty(preDatas)?preDatas.size():MongoConstant.ZERO);
        //若存在存昨日数据储到map
        if(CollectionUtils.isNotEmpty(preDatas)){
            preDatas.stream().forEach(preData->mapPreData.put(MongoSomeUtils.concat(preData.getCertificateid().toString(),preData.getAppKey()),preData));
        }
        //批量新增
        insertBach(commonRos, hour, collectionName,mapPreData,SumType.CERTIFICATE_APP.getCode());
    }

    /**
     * 以礼券维度批量新增
     *
     * @param datetime
     * @param hour
     * @return void
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    private synchronized void dealCertificate(String datetime, Integer hour) throws ParseException {
        //获取集合名称
        String collectionName = MongoSomeUtils.getCountCertificateHourCollectionName(datetime);
        //条件
        Query query=new Query(Criteria.where(MongoConstant.HOUR).is(hour));
        //删除里面存在的历史记录
        ticketCountHourDao.remove(query, collectionName);
        //查询礼券维度
        List<CommonRo> commonRos = awardDetailService.taskForCertificate(datetime, hour);
        //查询昨天的数据，计算涨幅
        List<TicketCountHour> preDatas = ticketCountHourDao.find(query,MongoSomeUtils.getCountCertificateHourCollectionName(MongoSomeUtils.getPreDate(datetime)));
        //声明存储map,减少遍历
        Map<String,TicketCountHour> mapPreData=new HashMap<String,TicketCountHour>(CollectionUtils.isNotEmpty(preDatas)?preDatas.size():MongoConstant.ZERO);
        //若存在存昨日数据储到map
        if(CollectionUtils.isNotEmpty(preDatas)){
            preDatas.stream().forEach(preData->mapPreData.put(preData.getCertificateid().toString(),preData));
        }
        //批量新增
        insertBach(commonRos, hour, collectionName,mapPreData,SumType.CERTIFICATE.getCode());
    }


    private void insertBach(List<CommonRo> commonRos, Integer hour, String collectionName,Map<String,TicketCountHour> mapPreData,Integer sumType) {
        //若为空，就不用走了
        if (CollectionUtils.isEmpty(commonRos)) {
            return;
        }
        //存储插入的集合啊
        List<TicketCountHour> list = new ArrayList<TicketCountHour>();
        //遍历一哈哈
        if (SumType.CERTIFICATE.getCode().equals(sumType)) {
            //礼券维度
            commonRos.stream().forEach(commonRo -> {
                list.add(MongoSomeUtils.dealChange(mapPreData.get(commonRo.getCertificateid().toString()),commonRo,hour));
                if (list.size() == MongoConstant.DEFAULT_COUNT) {
                    ticketCountHourDao.saveBatch(list, collectionName);
                    list.clear();
                }
            });
        }else if (SumType.CERTIFICATE_APP.getCode().equals(sumType)) {
            //若是开发者维度
                commonRos.stream().forEach(commonRo -> {
                list.add(MongoSomeUtils.dealChange(mapPreData.get(MongoSomeUtils.concat(commonRo.getCertificateid().toString(),commonRo.getAppKey())),commonRo,hour));
                if (list.size() == MongoConstant.DEFAULT_COUNT) {
                    ticketCountHourDao.saveBatch(list, collectionName);
                    list.clear();
                }
            });
            } else if (SumType.CERTIFICATE_APP_BUSINESS.getCode().equals(sumType)) {
            //若是子链接维度
                commonRos.stream().forEach(commonRo -> {
                    list.add(MongoSomeUtils.dealChange(mapPreData.get(MongoSomeUtils.concat(MongoSomeUtils.concat(commonRo.getCertificateid().toString(),commonRo.getAppKey()),commonRo.getBusiness())),commonRo,hour));
                    if (list.size() == MongoConstant.DEFAULT_COUNT) {
                        ticketCountHourDao.saveBatch(list, collectionName);
                        list.clear();
                    }
                });
            }

        //最后一波也需要上岸
        if (CollectionUtils.isNotEmpty(list)) {
            ticketCountHourDao.saveBatch(list, collectionName);
        }
    }

    /**
     * 分页查询
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param certificateid 礼券 ID
     * @param appkey 开发者标志
     * @param business 子渠道标志
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @param pageSize 当前页面大小
     * @param pageNum 当前页码
     * @param sortName 排序字段
     * @param sortType 排序方式
     * @return com.bxm.datapark.dal.mongo.base.Page<com.bxm.datapark.dal.mongo.vo.TicketCountHour>
     */
    public Page<TicketCountHourRo> findCountForHour(
            Long certificateid,
            String appkey,
            String business,
            String datetime,
            Integer sHour,
            Integer eHour,
            Integer pageSize,
            Integer pageNum,
            String sortName,
            String sortType) {
        //集合名称
        String collectionName = MongoSomeUtils.getCollectionName(appkey, business, datetime);
        //查询吧，骚年
        Page<TicketCountHour> page = ticketCountHourDao.findPage(pageNum, pageSize, MongoSomeUtils.getCountHourQuery(certificateid, appkey, business, sHour, eHour, sortName, sortType),collectionName);

        //若没查询到就不想走下去了
        if(MongoConstant.ZERO.equals(page.getSize())){
            return new Page<TicketCountHourRo>(null,pageNum,pageSize,null);
        }

        //查询合计
        List<TicketCountHour> count=ticketCountHourDao.sum(collectionName,MongoSomeUtils.getMatch(certificateid, appkey, business, sHour, eHour),MongoSomeUtils.getGroup(appkey, business));
        //前一日合计
        List<TicketCountHour> countPre=ticketCountHourDao.sum(MongoSomeUtils.getCollectionName(appkey, business, MongoSomeUtils.getPreDate(datetime)),MongoSomeUtils.getMatch(certificateid, appkey, business, sHour, eHour),MongoSomeUtils.getGroup(appkey, business));
        //整合数据
        if(CollectionUtils.isEmpty(count)){
            return new Page<TicketCountHourRo>(null,pageNum,pageSize,null);
        }
        //获取合计的数据
        TicketCountHour countHour=count.get(MongoConstant.ZERO.intValue());
        TicketCountHour countHourPre=new TicketCountHour();
        //若不为空
        if(CollectionUtils.isNotEmpty(countPre)){
            countHourPre=countPre.get(MongoConstant.ZERO.intValue());
        }

        //声明结果集,并复制 bean
        Page<TicketCountHourRo> rs=new Page<>();
        //声明结果集保存结果
        List<TicketCountHourRo> list=new ArrayList<TicketCountHourRo>();
        //复制 bean
        BeanUtils.copyProperties(page,rs);
        //获取当日和前一日的发券量
        Integer totalOpenPv=countHour.getOpenPv();
        Integer totalOpenPvPre=countHourPre.getOpenPv();
        Integer totalClickPv=countHour.getClickPv();
        Integer totalClickPvPre=countHourPre.getClickPv();

        //有效点击率计算
        countHour.setValidClickRate(MongoSomeUtils.getConversion(countHour.getValidClick(),totalClickPv));
        countHourPre.setValidClickRate(MongoSomeUtils.getConversion( countHourPre.getValidClick(), totalClickPvPre));

        //转换率
        countHour.setConversion(MongoSomeUtils.getConversion(totalClickPv, totalOpenPv));
        countHourPre.setConversion(MongoSomeUtils.getConversion(totalClickPvPre, totalOpenPvPre));
        //计算合计涨幅
        countHour=MongoSomeUtils.dealChange(countHourPre,countHour);
        //添加至 list
        list.add(MongoSomeUtils.dealOtherThing(countHour,totalOpenPv,totalOpenPvPre, MongoConstant.COUNT_CN));

        //编码
        Integer number = Integer.valueOf((pageNum - MongoConstant.ONE) * pageSize);
        //遍历一次试试
        for(TicketCountHour ticketCountHour:page.getList()){
            list.add(MongoSomeUtils.dealOtherThing(ticketCountHour,totalOpenPv,totalOpenPvPre,(++number).toString()));
        }
        //放进分页集合
        rs.setList(list);
        //返回结果
        return rs;

    }

    /**
     * 导出报表，查询全部
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param certificateid 礼券 ID
     * @param appkey 开发者标志
     * @param business 子渠道标志
     * @param datetime 查询日期
     * @param sHour 开始时段
     * @param eHour 结束时段
     * @return com.bxm.datapark.dal.mongo.base.Page<com.bxm.datapark.dal.mongo.vo.TicketCountHour>
     */
    public List<TicketCountHourRo> findCountForHour(
            Long certificateid,
            String appkey,
            String business,
            String datetime,
            Integer sHour,
            Integer eHour) {
        //集合名称
        String collectionName = MongoSomeUtils.getCollectionName(appkey, business, datetime);
        //查询吧，骚年
        List<TicketCountHour> data = ticketCountHourDao.find(MongoSomeUtils.getCountHourQuery(certificateid, appkey, business, sHour, eHour, MongoConstant.HOUR, MongoConstant.SORT_TYPE_ASC),collectionName);

        //若没查询到就不想走下去了
        if(CollectionUtils.isEmpty(data)){
            return new ArrayList<TicketCountHourRo>();
        }

        //查询合计
        List<TicketCountHour> count=ticketCountHourDao.sum(collectionName,MongoSomeUtils.getMatch(certificateid, appkey, business, sHour, eHour),MongoSomeUtils.getGroup(appkey, business));
        //前一日合计
        List<TicketCountHour> countPre=ticketCountHourDao.sum(MongoSomeUtils.getCollectionName(appkey, business, MongoSomeUtils.getPreDate(datetime)),MongoSomeUtils.getMatch(certificateid, appkey, business, sHour, eHour),MongoSomeUtils.getGroup(appkey, business));

        //整合数据
        //整合数据
        if(CollectionUtils.isEmpty(count)){
            return new ArrayList<TicketCountHourRo>();
        }
        //获取合计的数据
        TicketCountHour countHour=count.get(MongoConstant.ZERO.intValue());
        TicketCountHour countHourPre=new TicketCountHour();
        //若不为空
        if(CollectionUtils.isNotEmpty(countPre)){
            countHourPre=countPre.get(MongoConstant.ZERO.intValue());
        }
        //声明结果集,并复制 bean
        Integer totalOpenPv=countHour.getOpenPv();
        Integer totalOpenPvPre=countHourPre.getOpenPv();
        Integer totalClickPv=countHour.getClickPv();
        Integer totalClickPvPre=countHourPre.getClickPv();

        //有效点击率计算
        countHour.setValidClickRate(MongoSomeUtils.getConversion(countHour.getValidClick(),totalClickPv));
        countHourPre.setValidClickRate(MongoSomeUtils.getConversion( countHourPre.getValidClick(), totalClickPvPre));

        //转换率
        countHour.setConversion(MongoSomeUtils.getConversion(totalClickPv, totalOpenPv));
        countHourPre.setConversion(MongoSomeUtils.getConversion(totalClickPvPre, totalOpenPvPre));
        //声明 list
        List<TicketCountHourRo> list=new ArrayList<TicketCountHourRo>();
        //处理合计涨幅度
        countHour=MongoSomeUtils.dealChange(countHourPre,countHour);
        //添加至 list
        list.add(MongoSomeUtils.dealOtherThing(countHour,totalOpenPv,totalOpenPvPre,MongoConstant.COUNT_CN));

        //编码
        Integer number = Integer.valueOf(MongoConstant.ZERO);
        //遍历一次试试
        for(TicketCountHour ticketCountHour:data){
            list.add(MongoSomeUtils.dealOtherThing(ticketCountHour,totalOpenPv,totalOpenPvPre,(++number).toString()));
        }
        //返回结果
        return list;

    }


}
