package com.bxm.datapark.service.service;

import com.alibaba.fastjson.JSON;
import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.base.Page;
import com.bxm.datapark.dal.mongo.dao.TicketCountAppDao;
import com.bxm.datapark.dal.mongo.dao.TicketCountBusinessDao;
import com.bxm.datapark.dal.mongo.dao.TicketCountDao;
import com.bxm.datapark.dal.mongo.ro.CommonRo;
import com.bxm.datapark.dal.mongo.vo.TicketCount;
import com.bxm.datapark.dal.mongo.vo.TicketCountApp;
import com.bxm.datapark.dal.mongo.vo.TicketCountBusiness;
import com.bxm.datapark.service.util.MongoSomeUtils;
import com.bxm.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.service.service.TicketService.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-06 16:29:00
 * @modifier 董朱旭
 * @updated 2018-01-06 16:29:00
 * @description
 */
@Service
public class TicketService {

    @Autowired
    private TicketCountDao ticketCountDao;

    @Autowired
    private TicketCountAppDao ticketCountAppDao;

    @Autowired
    private TicketCountBusinessDao ticketCountBusinessDao;

    @Autowired
    private AwardDetailService awardDetailService;


    private static final Logger log = LoggerFactory.getLogger(TicketService.class);


    /*
     *  聚合统计插入礼券维度报表
     * @author zhangkai
     * @date 2018/1/9 16:23
     * @param
     * @return
     */
    public synchronized void insertCertificate(String datetime) {
        try {
            List<CommonRo> list = awardDetailService.taskForCertificate(datetime, null);
            String collectionName = MongoSomeUtils.getCertificateCollectionName(datetime);
            List<TicketCount> listPre = ticketCountDao.find(new Query(), MongoSomeUtils.getCertificateCollectionName(MongoSomeUtils.getPreDate(datetime)));
            Map<String, TicketCount> mapPreData = new HashMap<String, TicketCount>(CollectionUtils.isNotEmpty(listPre) ? listPre.size() : MongoConstant.ZERO);
            //若存在存昨日数据储到map
            if (CollectionUtils.isNotEmpty(listPre)) {
                listPre.stream().forEach(preData -> mapPreData.put(preData.getCertificateid().toString(), preData));
            }
            //删除历史数据
            ticketCountAppDao.drop(collectionName);
            //查询集合为空则return
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            List<TicketCount> ticketCounts = new ArrayList<>();
            list.stream().forEach(commonRo -> {
                TicketCount ticketCount = new TicketCount();
                BeanUtils.copyProperties(commonRo, ticketCount);
                //涨幅都处理
                ticketCount = MongoSomeUtils.dealChange(mapPreData.get(commonRo.getCertificateid().toString()), ticketCount);
                ticketCounts.add(ticketCount);
                if (ticketCounts.size() == MongoConstant.DEFAULT_COUNT) {
                    ticketCountDao.saveBatch(ticketCounts, collectionName);
                    ticketCounts.clear();
                }
            });
            //最后一波也需要上岸
            if (CollectionUtils.isNotEmpty(ticketCounts)) {
                ticketCountDao.saveBatch(ticketCounts, collectionName);
            }

        } catch (ParseException e) {
            log.error("ParseException", e);
        }
    }

    /*
     *  聚合统计插入开发者维度报表
     * @author zhangkai
     * @date 2018/1/9 16:23
     * @param
     * @return
     */
    public synchronized void insertApp(String datetime) {
        try {
            List<CommonRo> list = awardDetailService.taskForApp(datetime, null);
            String collectionName = MongoSomeUtils.getAppCollectionName(datetime);
            //删除历史数据
            ticketCountAppDao.drop(collectionName);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            List<TicketCountApp> listPre = ticketCountAppDao.find(new Query(), MongoSomeUtils.getAppCollectionName(MongoSomeUtils.getPreDate(datetime)));
            Map<String, TicketCountApp> mapPreData = new HashMap<String, TicketCountApp>(CollectionUtils.isNotEmpty(listPre) ? listPre.size() : MongoConstant.ZERO);
            //若存在存昨日数据储到map
            if (CollectionUtils.isNotEmpty(listPre)) {
                listPre.stream().forEach(preData -> mapPreData.put(MongoSomeUtils.concat(preData.getCertificateid().toString(), preData.getAppKey()), preData));
            }
            List<TicketCountApp> ticketCountApps = new ArrayList<>();
            list.stream().forEach(commonRo -> {
                TicketCountApp app = new TicketCountApp();
                BeanUtils.copyProperties(commonRo, app);
                //涨幅都处理
                app = MongoSomeUtils.dealChange(mapPreData.get(MongoSomeUtils.concat(commonRo.getCertificateid().toString(), commonRo.getAppKey())), app);
                ticketCountApps.add(app);
                if (ticketCountApps.size() == MongoConstant.DEFAULT_COUNT) {
                    ticketCountAppDao.saveBatch(ticketCountApps, collectionName);
                    ticketCountApps.clear();
                }
            });
            //最后一波也需要上岸
            if (CollectionUtils.isNotEmpty(ticketCountApps)) {
                ticketCountAppDao.saveBatch(ticketCountApps, collectionName);
            }
        } catch (ParseException e) {
            log.error("ParseException", e);
        }
    }

    /*
     *  聚合统计插入开发者渠道维度报表
     * @author zhangkai
     * @date 2018/1/9 16:23
     * @param
     * @return
     */
    public synchronized void insertBusiness(String datetime) {
        try {
            List<CommonRo> list = awardDetailService.taskForBusiness(datetime, null);
            String collectionName = MongoSomeUtils.getBusinessCollectionName(datetime);
            //删除历史数据
            ticketCountAppDao.drop(collectionName);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            List<TicketCountBusiness> listPre = ticketCountBusinessDao.find(new Query(), MongoSomeUtils.getBusinessCollectionName(MongoSomeUtils.getPreDate(datetime)));
            Map<String, TicketCountBusiness> mapPreData = new HashMap<String, TicketCountBusiness>(CollectionUtils.isNotEmpty(listPre) ? listPre.size() : MongoConstant.ZERO);
            //若存在存昨日数据储到map
            if (CollectionUtils.isNotEmpty(listPre)) {
                listPre.stream().forEach(preData -> mapPreData.put(MongoSomeUtils.concat(MongoSomeUtils.concat(preData.getCertificateid().toString(), preData.getAppKey()), preData.getBusiness()), preData));
            }
            List<TicketCountBusiness> businesses = new ArrayList<>();
            list.stream().forEach(commonRo -> {
                TicketCountBusiness business = new TicketCountBusiness();
                BeanUtils.copyProperties(commonRo, business);
                //涨幅都处理
                business = MongoSomeUtils.dealChange(mapPreData.get(MongoSomeUtils.concat(MongoSomeUtils.concat(commonRo.getCertificateid().toString(), commonRo.getAppKey()), commonRo.getBusiness())), business);
                businesses.add(business);
                if (businesses.size() == MongoConstant.DEFAULT_COUNT) {
                    ticketCountBusinessDao.saveBatch(businesses, collectionName);
                    businesses.clear();
                }
            });

            //最后一波也需要上岸
            if (CollectionUtils.isNotEmpty(businesses)) {
                ticketCountBusinessDao.saveBatch(businesses, collectionName);
            }
        } catch (ParseException e) {
            log.error("ParseException", e);
        }
    }

    public void ticketTask(String datetime) {

        //统计礼券维度
        insertCertificate(datetime);

        //统计APP维度
        insertApp(datetime);

        //统计APP渠道维度
        insertBusiness(datetime);
    }


    /*
     *  查询礼券统计
     * @author zhangkai
     * @date 2018/1/10 16:43
     * @param
     * @return
     */
    public Page<TicketCount> findTicketCount(String datetime, String certificateid, String sortName,
                                             Integer pageNum, Integer pageSize, String sortType) {
        //查询统计结果
        String mongoName = MongoSomeUtils.getCertificateCollectionName(datetime);
        Query query = new Query();
        if (MongoConstant.SORT_TYPE_ASC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.ASC, sortName));
        } else if (MongoConstant.SORT_TYPE_DESC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.DESC, sortName));
        }
        Criteria criteria = new Criteria();
        if (!StringUtil.isEmpty(certificateid)) {
            List<Long> certificateIdArray = JSON.parseArray(certificateid, Long.class);
            query.addCriteria(Criteria.where("certificateid").in(certificateIdArray));
            criteria.and(MongoConstant.CERTIFICATEID).in(certificateIdArray);
        }
        Page<TicketCount> page = ticketCountDao.findPage(pageNum, pageSize, query, mongoName);

        MatchOperation match = Aggregation.match(criteria);
        TicketCount ticketCount = new TicketCount();

        List<TicketCount> ticketCounts = ticketCountDao.sum(mongoName, match, Aggregation.group().sum("openPv").as("openPv").sum("clickPv").as("clickPv").
                sum("validClick").as("validClick").
                sum("validClickRate").as("validClickRate").
                sum("conversion").as("conversion").
                sum("sendPv").as("sendPv"));
        if (CollectionUtils.isNotEmpty(ticketCounts)) {
            ticketCount = ticketCounts.get(0);
        }
        List<TicketCount> ticketCountList = page.getList();

        for (TicketCount ticketCount1 : ticketCountList) {
            if(ticketCount1.getOpenPv()!=null) {
                ticketCount1.setOpenPvRate(MongoSomeUtils.getConversion(ticketCount1.getOpenPv(), ticketCount.getOpenPv()).multiply(new BigDecimal(100)));
            }
            if(ticketCount1.getConversion()!=null){
                ticketCount1.setConversion(ticketCount1.getConversion().multiply(new BigDecimal(100)));
            }
        }
        //转化率
        ticketCount.setConversion(MongoSomeUtils.getConversion(ticketCount.getClickPv(),ticketCount.getOpenPv()));
        //发券占比
        if(ticketCount.getOpenPv()!=null&&ticketCount.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCount.setOpenPvRate(MongoSomeUtils.getConversion(ticketCount.getOpenPv(), ticketCount.getOpenPv()).multiply(new BigDecimal(100)));
        }
        //有效点击率
        ticketCount.setValidClickRate(MongoSomeUtils.getConversion(ticketCount.getValidClick(),ticketCount.getClickPv()));

        ticketCountList.add(0, ticketCount);
        return page;
    }

    /**
     * 导出礼券维度的报表
     *
     * @param datetime
     * @param certificateid
     * @return java.util.List<com.bxm.datapark.dal.mongo.vo.TicketCount>
     * @author 董朱旭
     * @time 2018/1/16
     * @CopyRight 杭州微财网络科技有限公司
     */
    public List<TicketCount> findTicketCount(String datetime, String certificateid) {
        //查询统计结果
        String mongoName = MongoSomeUtils.getCertificateCollectionName(datetime);
        Query query = new Query();

        Criteria criteria = new Criteria();
        if (!StringUtil.isEmpty(certificateid)) {
            List<Long> certificateIdArray = JSON.parseArray(certificateid, Long.class);
            query.addCriteria(Criteria.where("certificateid").in(certificateIdArray));
            criteria.and(MongoConstant.CERTIFICATEID).in(certificateIdArray);
        }
        List<TicketCount> list = ticketCountDao.find(query, mongoName);

        MatchOperation match = Aggregation.match(criteria);
        TicketCount ticketCount = new TicketCount();

        List<TicketCount> ticketCounts = ticketCountDao.sum(mongoName, match, Aggregation.group().sum("openPv").as("openPv").sum("clickPv").as("clickPv").
                sum("validClick").as("validClick").
                sum("validClickRate").as("validClickRate").
                sum("conversion").as("conversion").
                sum("sendPv").as("sendPv"));
        if (CollectionUtils.isNotEmpty(ticketCounts)) {
            ticketCount = ticketCounts.get(0);
        }

        for (TicketCount ticketCount1 : list) {
            if (ticketCount1.getOpenPv() != null) {
                ticketCount1.setOpenPvRate(MongoSomeUtils.getConversion(ticketCount1.getOpenPv(), ticketCount.getOpenPv()).multiply(new BigDecimal(100)));
            }
            if(ticketCount1.getConversion() != null) {
                ticketCount1.setConversion(ticketCount1.getConversion().multiply(new BigDecimal(100)));
            }
        }
        //转化率
        ticketCount.setConversion(MongoSomeUtils.getConversion(ticketCount.getClickPv(),ticketCount.getOpenPv()));
        //发券占比
        if(ticketCount.getOpenPv()!=null&&ticketCount.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCount.setOpenPvRate(MongoSomeUtils.getConversion(ticketCount.getOpenPv(), ticketCount.getOpenPv()).multiply(new BigDecimal(100)));
        }
        //有效点击率
        ticketCount.setValidClickRate(MongoSomeUtils.getConversion(ticketCount.getValidClick(),ticketCount.getClickPv()));
        list.add(0, ticketCount);
        return list;
    }

    /*
     * 查询开发者维度
     * @author zhangkai
     * @date 2018/1/10 16:43
     * @param
     * @return
     */
    public Page<TicketCountApp> findTicketCountApp(String datetime, String certificateid, String appKey, String sortName, String sortType, Integer pageNum, Integer pageSize) {
        String mongoName = MongoSomeUtils.getAppCollectionName(datetime);
        Query query = new Query();
        if (MongoConstant.SORT_TYPE_ASC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.ASC, sortName));
        } else if (MongoConstant.SORT_TYPE_DESC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.DESC, sortName));
        }
        Criteria criteria = Criteria.where(MongoConstant.CERTIFICATEID).is(Long.valueOf(certificateid));
        query.addCriteria(Criteria.where("certificateid").is(Long.valueOf(certificateid)));

        if (StringUtil.isNotEmpty(appKey)) {
            List<String> appKeyArray = JSON.parseArray(appKey, String.class);
            query.addCriteria(Criteria.where("appKey").in(appKeyArray));
            criteria.and(MongoConstant.APPKEY_VO).in(appKeyArray);
        }
        Page<TicketCountApp> page = ticketCountAppDao.findPage(pageNum, pageSize, query, mongoName);

        MatchOperation match = Aggregation.match(criteria);
        List<TicketCountApp> ticketCountApps = ticketCountAppDao.sum(mongoName, match, Aggregation.group().sum("openPv").as("openPv").sum("clickPv").as("clickPv").
                sum("validClick").as("validClick").
                sum("validClickRate").as("validClickRate").
                sum("conversion").as("conversion").
                sum("sendPv").as("sendPv"));


        TicketCountApp ticketCountApp = new TicketCountApp();
        if (CollectionUtils.isNotEmpty(ticketCountApps)) {
            ticketCountApp = ticketCountApps.get(0);
        }
        List<TicketCountApp> ticketCountApps1 = page.getList();
        if (ticketCountApp.getOpenPv() != null) {
            for (TicketCountApp ticketCountApp1 : ticketCountApps1) {
                if (ticketCountApp1.getOpenPv() != null) {
                    ticketCountApp1.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountApp1.getOpenPv(), ticketCountApp.getOpenPv()).multiply(new BigDecimal(100)));
                }
                if (ticketCountApp1.getConversion() != null) {
                    ticketCountApp1.setConversion(ticketCountApp1.getConversion().multiply(new BigDecimal(100)));
                }
            }
        }
        //转化率
        ticketCountApp.setConversion(MongoSomeUtils.getConversion(ticketCountApp.getClickPv(),ticketCountApp.getOpenPv()));
        //发券占比
        if(ticketCountApp.getOpenPv()!=null&&ticketCountApp.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCountApp.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountApp.getOpenPv(), ticketCountApp.getOpenPv()).multiply(new BigDecimal(100)));
        }
        //有效点击率
        ticketCountApp.setValidClickRate(MongoSomeUtils.getConversion(ticketCountApp.getValidClick(),ticketCountApp.getClickPv()));
        ticketCountApps1.add(0, ticketCountApp);
        return page;
    }

    /**
     * 获取开发者的维度报表
     *
     * @param datetime
     * @param certificateid
     * @param appKey
     * @return java.util.List<com.bxm.datapark.dal.mongo.vo.TicketCountApp>
     * @author 董朱旭
     * @time 2018/1/16
     * @CopyRight 杭州微财网络科技有限公司
     */
    public List<TicketCountApp> findTicketCountApp(String datetime, String certificateid, String appKey) {
        String mongoName = MongoSomeUtils.getAppCollectionName(datetime);
        Query query = new Query();
        Criteria criteria = Criteria.where(MongoConstant.CERTIFICATEID).is(Long.valueOf(certificateid));
        query.addCriteria(Criteria.where("certificateid").is(Long.valueOf(certificateid)));

        if (StringUtil.isNotEmpty(appKey)) {
            List<String> appKeyArray = JSON.parseArray(appKey, String.class);
            query.addCriteria(Criteria.where("appKey").in(appKeyArray));
            criteria.and(MongoConstant.APPKEY_VO).in(appKeyArray);
        }
        List<TicketCountApp> list = ticketCountAppDao.find(query, mongoName);

        MatchOperation match = Aggregation.match(criteria);
        List<TicketCountApp> ticketCountApps = ticketCountAppDao.sum(mongoName, match, Aggregation.group().sum("openPv").as("openPv").sum("clickPv").as("clickPv").
                sum("validClick").as("validClick").
                sum("validClickRate").as("validClickRate").
                sum("conversion").as("conversion").
                sum("sendPv").as("sendPv"));


        TicketCountApp ticketCountApp = new TicketCountApp();
        if (CollectionUtils.isNotEmpty(ticketCountApps)) {
            ticketCountApp = ticketCountApps.get(0);
        }
        if (ticketCountApp.getOpenPv() != null) {
            for (TicketCountApp ticketCountApp1 : list) {
                if (ticketCountApp1.getOpenPv() != null) {
                    ticketCountApp1.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountApp1.getOpenPv(), ticketCountApp.getOpenPv()).multiply(new BigDecimal(100)));
                }
                if (ticketCountApp1.getConversion() != null) {
                    ticketCountApp1.setConversion(ticketCountApp1.getConversion().multiply(new BigDecimal(100)));
                }
            }
        }
        //转化率
        ticketCountApp.setConversion(MongoSomeUtils.getConversion(ticketCountApp.getClickPv(),ticketCountApp.getOpenPv()));
        //发券占比
        if(ticketCountApp.getOpenPv()!=null&&ticketCountApp.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCountApp.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountApp.getOpenPv(), ticketCountApp.getOpenPv()).multiply(new BigDecimal(100)));
        }
        //有效点击率
        ticketCountApp.setValidClickRate(MongoSomeUtils.getConversion(ticketCountApp.getValidClick(),ticketCountApp.getClickPv()));
        list.add(0, ticketCountApp);
        return list;
    }

    /*
     *  查询子渠道维度
     * @author zhangkai
     * @date 2018/1/10 16:44
     * @param
     * @return
     */
    public Page<TicketCountBusiness> findTicketCountBusiness(String datetime, String certificateid, String appKey, String business, String sortName, String sortType, Integer pageNum, Integer pageSize) {
        String mongoName = MongoSomeUtils.getBusinessCollectionName(datetime);
        Query query = new Query();
        if (MongoConstant.SORT_TYPE_ASC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.ASC, sortName));
        } else if (MongoConstant.SORT_TYPE_DESC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.DESC, sortName));
        }
        Criteria criteria = Criteria.where(MongoConstant.CERTIFICATEID).is(Long.valueOf(certificateid));
        query.addCriteria(Criteria.where("certificateid").is(Long.valueOf(certificateid)).and("appKey").is(appKey));
        criteria.and(MongoConstant.APPKEY_VO).is(appKey);
        if (StringUtil.isNotEmpty(business)) {
            query.addCriteria(Criteria.where("business").is(business));
            criteria.and(MongoConstant.BUSINESS).is(business);
        }
        Page<TicketCountBusiness> page = ticketCountBusinessDao.findPage(pageNum, pageSize, query, mongoName);

        MatchOperation match = Aggregation.match(criteria);
        List<TicketCountBusiness> ticketCountBusinesses = ticketCountBusinessDao.sum(mongoName, match, Aggregation.group().sum("openPv").as("openPv").sum("clickPv").as("clickPv").
                sum("validClick").as("validClick").
                sum("validClickRate").as("validClickRate").
                sum("conversion").as("conversion").
                sum("sendPv").as("sendPv"));

        TicketCountBusiness ticketCountBusiness = new TicketCountBusiness();
        if (CollectionUtils.isNotEmpty(ticketCountBusinesses)) {
            ticketCountBusiness = ticketCountBusinesses.get(0);
        }
        List<TicketCountBusiness> ticketCountBusinesses1 = page.getList();
        for (TicketCountBusiness ticketCountBusiness1 : ticketCountBusinesses1) {
            if (ticketCountBusiness1.getOpenPv() != null) {
                ticketCountBusiness1.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountBusiness1.getOpenPv(), ticketCountBusiness.getOpenPv()).multiply(new BigDecimal(100)));
            }
            if (ticketCountBusiness1.getConversion() != null) {
                ticketCountBusiness1.setConversion(ticketCountBusiness1.getConversion().multiply(new BigDecimal(100)));
            }

            //ticketCountBusiness1.setOpenPvRate(new BigDecimal(ticketCountBusiness1.getOpenPv()).divide(new BigDecimal(ticketCountBusiness.getOpenPv()),BigDecimal.ROUND_HALF_UP));
        }
        //转化率
        ticketCountBusiness.setConversion(MongoSomeUtils.getConversion(ticketCountBusiness.getClickPv(),ticketCountBusiness.getOpenPv()));
        //发券占比
        if(ticketCountBusiness.getOpenPv()!=null&&ticketCountBusiness.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCountBusiness.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountBusiness.getOpenPv(), ticketCountBusiness.getOpenPv()).multiply(new BigDecimal(100)));
        }
        //有效点击率
        ticketCountBusiness.setValidClickRate(MongoSomeUtils.getConversion(ticketCountBusiness.getValidClick(),ticketCountBusiness.getClickPv()));
        ticketCountBusinesses1.add(0, ticketCountBusiness);
        return page;
    }

    /**
     * 导出子链接维度
     *
     * @param datetime
     * @param certificateid
     * @param appKey
     * @param business
     * @return java.util.List<com.bxm.datapark.dal.mongo.vo.TicketCountBusiness>
     * @author 董朱旭
     * @time 2018/1/16
     * @CopyRight 杭州微财网络科技有限公司
     */
    public List<TicketCountBusiness> findTicketCountBusiness(String datetime, String certificateid, String appKey, String business) {
        String mongoName = MongoSomeUtils.getBusinessCollectionName(datetime);
        Query query = new Query();
        Criteria criteria = Criteria.where(MongoConstant.CERTIFICATEID).is(Long.valueOf(certificateid));
        query.addCriteria(Criteria.where("certificateid").is(Long.valueOf(certificateid)).and("appKey").is(appKey));
        criteria.and(MongoConstant.APPKEY_VO).is(appKey);
        if (StringUtil.isNotEmpty(business)) {
            query.addCriteria(Criteria.where("business").is(business));
            criteria.and(MongoConstant.BUSINESS).is(business);
        }
        List<TicketCountBusiness> list = ticketCountBusinessDao.find(query, mongoName);

        MatchOperation match = Aggregation.match(criteria);
        List<TicketCountBusiness> ticketCountBusinesses = ticketCountBusinessDao.sum(mongoName, match, Aggregation.group().sum("openPv").as("openPv").sum("clickPv").as("clickPv").
                sum("validClick").as("validClick").
                sum("validClickRate").as("validClickRate").
                sum("conversion").as("conversion").
                sum("sendPv").as("sendPv"));

        TicketCountBusiness ticketCountBusiness = new TicketCountBusiness();
        if (CollectionUtils.isNotEmpty(ticketCountBusinesses)) {
            ticketCountBusiness = ticketCountBusinesses.get(0);
        }
        for (TicketCountBusiness ticketCountBusiness1 : list) {
            if(ticketCountBusiness1.getOpenPv()!=null) {
                ticketCountBusiness1.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountBusiness1.getOpenPv(), ticketCountBusiness.getOpenPv()).multiply(new BigDecimal(100)));
            }
            if (ticketCountBusiness1.getConversion() != null) {
                ticketCountBusiness1.setConversion(ticketCountBusiness1.getConversion().multiply(new BigDecimal(100)));
            }
        }
        //转化率
        ticketCountBusiness.setConversion(MongoSomeUtils.getConversion(ticketCountBusiness.getClickPv(),ticketCountBusiness.getOpenPv()));
        //发券占比
        if(ticketCountBusiness.getOpenPv()!=null&&ticketCountBusiness.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCountBusiness.setOpenPvRate(MongoSomeUtils.getConversion(ticketCountBusiness.getOpenPv(), ticketCountBusiness.getOpenPv()).multiply(new BigDecimal(100)));
        }
        //有效点击率
        ticketCountBusiness.setValidClickRate(MongoSomeUtils.getConversion(ticketCountBusiness.getValidClick(),ticketCountBusiness.getClickPv()));
        list.add(0, ticketCountBusiness);
        return list;
    }

    /*
     * 广告券按日
     * @author zhangkai
     * @date 2018/1/10 16:59
     * @param
     * @return
     */
    public List<TicketCount> findTicketByDatetime(String startTime, String endTime, String certificateid) {
        try {
            List<String> dateTimeList = new ArrayList<>();
            dateTimeList.add(startTime);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.setTime(sdf.parse(startTime));
            for (long d = cal.getTimeInMillis(); d <= sdf.parse(endTime).getTime(); d = get_D_Plaus_1(cal)) {
                dateTimeList.add(sdf.format(d));
            }
            dateTimeList.add(endTime);
            dateTimeList = new ArrayList(new HashSet(dateTimeList));
            if (CollectionUtils.isEmpty(dateTimeList)) {
                return null;
            }
            List<TicketCount> ticketCounts = new ArrayList<>();
            //查询所有的时间
            Integer sumOpenPv = 0;
            Integer sumSendPv = 0;
            Integer sumClickPv = 0;
            Integer sumValidClick = 0;
            BigDecimal sumValidClickRate = new BigDecimal(0);
            BigDecimal sumConversion = new BigDecimal(0);
            for (String dateTime : dateTimeList) {
                String mongoName = MongoSomeUtils.getBusinessCollectionName(dateTime);
                Query query = new Query();
                query.addCriteria(Criteria.where("certificateid").is(Long.valueOf(certificateid)));
                List<TicketCount> ticketCountss = ticketCountDao.find(query, mongoName);
                if (CollectionUtils.isEmpty(ticketCountss)) {
                    continue;
                } else {
                    TicketCount ticketCount = ticketCountss.get(0);
                    sumOpenPv = sumOpenPv + ticketCount.getOpenPv();
                    sumSendPv = sumSendPv + ticketCount.getSendPv();
                    sumClickPv = sumClickPv + ticketCount.getClickPv();
                    sumValidClick = sumValidClick + ticketCount.getValidClick();
                    sumValidClickRate = sumValidClickRate.add(ticketCount.getValidClickRate() == null ? new BigDecimal(0) : ticketCount.getValidClickRate());
                    sumConversion = sumConversion.add(ticketCount.getConversion());
                    ticketCount.setDatetime(dateTime);
                    ticketCounts.add(ticketCount);
                }
            }
            TicketCount ticketCount = new TicketCount(sumSendPv, sumClickPv, sumOpenPv, sumValidClick, sumValidClickRate, sumConversion);
            //转化率
            ticketCount.setConversion(MongoSomeUtils.getConversion(ticketCount.getClickPv(),ticketCount.getOpenPv()));
            //发券占比
            if(ticketCount.getOpenPv()!=null&&ticketCount.getOpenPv()!=MongoConstant.ZERO.intValue()) {
            ticketCount.setOpenPvRate(MongoSomeUtils.getConversion(ticketCount.getOpenPv(),ticketCount.getOpenPv()).multiply(new BigDecimal(100)));
            }
            //有效点击率
            ticketCount.setValidClickRate(MongoSomeUtils.getConversion(ticketCount.getValidClick(), ticketCount.getClickPv()));

            ticketCounts.add(0, ticketCount);
            return ticketCounts;
        } catch (ParseException e) {
            log.error("ParseException", e);
        }
        return null;
    }


    public static long get_D_Plaus_1(Calendar c) {
        c.set(Calendar.DAY_OF_MONTH, c.get(Calendar.DAY_OF_MONTH) + 1);
        return c.getTimeInMillis();
    }
}
