package com.bxm.datapark.service.util;

import com.aliyun.datahub.model.RecordEntry;
import com.bxm.datapark.dal.model.CountTicketAdvertiser;
import com.bxm.datapark.service.conf.DataCollectorManager;
import com.bxm.util.DateUtil;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @author zhangkai
 * @create 2018-01-05 14:38
 **/
@Component
public class CountAdvertiserDataHub {


    public RecordEntry insertEntrty(CountTicketAdvertiser countTicketAdvertiser,String messageId,RecordEntry entry){
        entry.setString("message_id",messageId);
        entry.setBigint("id",countTicketAdvertiser.getId());
        entry.setString("ipaddress", countTicketAdvertiser.getIpaddress());
        entry.setString("param",countTicketAdvertiser.getParam());
        entry.setString("phone", countTicketAdvertiser.getPhone());
        entry.setString("adshopcode", countTicketAdvertiser.getAdshopcode());
        entry.setBigint("status",  NumberUtils.ObjToNumber(countTicketAdvertiser.getStatus()));
        entry.setString("idcardnum", countTicketAdvertiser.getIdcardnum());
        entry.setString("shot_countid",  countTicketAdvertiser.getShotCountid());
        entry.setBigint("shot_activityid", NumberUtils.ObjToNumber(countTicketAdvertiser.getShotActivityid()));
        entry.setBigint("shot_certificateid", NumberUtils.ObjToNumber(countTicketAdvertiser.getShotCertificateid()));
        entry.setString("shot_appkey", countTicketAdvertiser.getShotAppkey());
        entry.setString("shot_ipaddress",countTicketAdvertiser.getShotIpaddress());
        entry.setString("shot_business", countTicketAdvertiser.getShotBusiness());
        entry.setString("shot_token",countTicketAdvertiser.getShotToken());
        entry.setString("modeltype", countTicketAdvertiser.getModeltype());
        entry.setTimeStamp("created",TimeUnit.MILLISECONDS.toMicros(countTicketAdvertiser.getCreated().getTime()));
        entry.setString("pt", DateUtil.dateTo8String(countTicketAdvertiser.getCreated()).replace("-",""));
        entry.setPartitionKey(countTicketAdvertiser.getShotAppkey());
        return entry;
    }



}
