package com.bxm.datapark.service.util;

import com.aliyun.odps.*;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.TableTunnel;
import com.bxm.datapark.dal.model.CountTicketAdvertiser;
import com.bxm.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 效果监控
 *
 * @author zhangkai
 * @create 2017-12-29 15:59
 **/
@Component
public class CountAdvertiserMaxCompute {

    private static final String accessId = "LTAIWvHd4WR8lqbC";
    private static final String accessKey = "YvSG81iMmZbRjHPE52YVgZcCvtzvEx";
    private static final String endPoint = "http://service.odps.aliyun.com/api";
    private static final String project = "MaxCompute_Task";
    private static final String partitionColumn = "pt";
    private static final String tableName = "count_certifiate_adshop_2";


    @Autowired
    private Account account;

    @Autowired
    private Odps odps;


    public  void uploadData(CountTicketAdvertiser countTicketAdvertiser){
        odps.setEndpoint(endPoint);
        odps.setDefaultProject(project);
        RecordWriter writer = null;
        try {
            TableTunnel tunnel = new TableTunnel(odps);
            PartitionSpec partitionSpec = new PartitionSpec();
            String ptDateTime = DateUtil.dateTo8String(countTicketAdvertiser.getCreated());
            partitionSpec.set(partitionColumn, ptDateTime.replace("-",""));
            Table table = odps.tables().get(tableName);//获取当前表
            boolean a= table.hasPartition(partitionSpec);//判断上述定义分区在表中是否存在
            if(a == false){
                table.createPartition(partitionSpec);
            }
            TableTunnel.UploadSession session = tunnel.createUploadSession(project,tableName,partitionSpec);
            RecordWriter rw = session.openRecordWriter(1);
            Column[] columns = new Column[16];
            columns[0] = new Column("id", OdpsType.BIGINT);
            columns[1] = new Column("ipaddress", OdpsType.STRING);
            columns[2] = new Column("param", OdpsType.STRING);
            columns[3] = new Column("phone", OdpsType.STRING);
            columns[4] = new Column("adshopcode", OdpsType.STRING);
            columns[5] = new Column("status", OdpsType.BIGINT);
            columns[6] = new Column("idcardnum", OdpsType.STRING);
            columns[7] = new Column("shot_countid", OdpsType.STRING);
            columns[8] = new Column("shot_activityid", OdpsType.BIGINT);
            columns[9] = new Column("shot_certificateid", OdpsType.BIGINT);
            columns[10] = new Column("shot_appkey", OdpsType.STRING);
            columns[11] = new Column("shot_ipaddress", OdpsType.STRING);
            columns[12] = new Column("shot_business", OdpsType.STRING);
            columns[13] = new Column("shot_token", OdpsType.STRING);
            columns[14] = new Column("modeltype", OdpsType.STRING);
            columns[15] = new Column("created", OdpsType.DATETIME);

            Record r = new ArrayRecord(columns);
            r.setBigint("id",countTicketAdvertiser.getId());
            r.setString("ipaddress", countTicketAdvertiser.getIpaddress());
            r.setString("param", countTicketAdvertiser.getParam());
            r.setString("phone", countTicketAdvertiser.getPhone());
            r.setString("adshopcode", countTicketAdvertiser.getAdshopcode());
            r.setBigint("status", (long)countTicketAdvertiser.getStatus());
            r.setString("idcardnum",countTicketAdvertiser.getIdcardnum());
            r.setString("shot_countid", countTicketAdvertiser.getShotCountid());
            r.setBigint("shot_activityid", countTicketAdvertiser.getShotActivityid());
            r.setBigint("shot_certificateid", countTicketAdvertiser.getShotCertificateid());
            r.setString("shot_appkey", countTicketAdvertiser.getShotAppkey());
            r.setString("shot_ipaddress",countTicketAdvertiser.getShotIpaddress());
            r.setString("shot_business",countTicketAdvertiser.getShotBusiness());
            r.setString("shot_token", countTicketAdvertiser.getShotToken());
            r.setString("modeltype", countTicketAdvertiser.getModeltype());
            r.setDatetime("created", countTicketAdvertiser.getCreated());
            rw.write(r);
            rw.close();//一定要close，不然无法commit
            Long[] blocks = session.getBlockList();
            session.commit(blocks);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
