package com.bxm.datapark.service.util;

import com.aliyun.datahub.model.RecordEntry;
import com.bxm.datapark.dal.model.CountAwradmsgDetail;
import com.bxm.util.DateUtil;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @author zhangkai
 * @create 2018-01-05 14:19
 **/

@Component
public class CountAwardDataHub {


    public RecordEntry insertEntrty(CountAwradmsgDetail countAwradmsgDetail ,String messageId,RecordEntry entry){
        entry.setString("message_id",messageId);
        entry.setBigint("countid",null);
        entry.setString("ipaddress", countAwradmsgDetail.getIpaddress());
        entry.setString("token",countAwradmsgDetail.getToken());
        entry.setString("appkey", countAwradmsgDetail.getAppkey());
        entry.setBigint("appos", NumberUtils.ObjToNumber(countAwradmsgDetail.getAppos()));
        entry.setString("modelname", countAwradmsgDetail.getModelname());
        entry.setBigint("modeltype", NumberUtils.ObjToNumber(countAwradmsgDetail.getModeltype()));
        entry.setBigint("awardtype", NumberUtils.ObjToNumber(countAwradmsgDetail.getAwardtype()));
        entry.setBigint("preid", NumberUtils.ObjToNumber(countAwradmsgDetail.getPreid()));
        entry.setBigint("activityid", NumberUtils.ObjToNumber(countAwradmsgDetail.getActivityid()));
        entry.setTimeStamp("clicktime", TimeUnit.MILLISECONDS.toMicros(countAwradmsgDetail.getClicktime().getTime()));
        entry.setString("remark", countAwradmsgDetail.getRemark());
        entry.setString("business", countAwradmsgDetail.getBusiness());
        entry.setString("deviceid", countAwradmsgDetail.getDeviceid());
        entry.setString("i", countAwradmsgDetail.getI());
        entry.setString("f", countAwradmsgDetail.getF());
        entry.setString("ua", countAwradmsgDetail.getUa());
        entry.setString("countid_new", countAwradmsgDetail.getCountid());
        entry.setString("pt", DateUtil.dateTo8String(countAwradmsgDetail.getClicktime()).replace("-",""));
        entry.setPartitionKey(countAwradmsgDetail.getAppkey());
        return entry;
    }

}
