package com.bxm.datapark.service.util;

import com.aliyun.odps.*;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.TableTunnel;
import com.bxm.datapark.dal.model.CountAwradmsgDetail;
import com.bxm.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;


/**
 * count_award_messageMaxCompute
 *
 * @author zhangkai
 * @create 2017-12-28 16:54
 **/
@Component
public class CountAwardMaxCompute {

    private static final String accessId = "LTAIWvHd4WR8lqbC";
    private static final String accessKey = "YvSG81iMmZbRjHPE52YVgZcCvtzvEx";
    private static final String endPoint = "http://service.odps.aliyun.com/api";
    private static final String project = "MaxCompute_Task";
    private static final String partitionColumn = "pt";
    private static final String tableName = "rds_count_awradmsg_detail_2";

    @Autowired
    private Account account;

    @Autowired
    private Odps odps;


    public  void uploadData(CountAwradmsgDetail countAwradmsgDetail){
        odps.setEndpoint(endPoint);
        odps.setDefaultProject(project);
        RecordWriter writer = null;
        try {
            TableTunnel tunnel = new TableTunnel(odps);
            PartitionSpec partitionSpec = new PartitionSpec();
            String ptDateTime = DateUtil.dateTo8String(countAwradmsgDetail.getClicktime());
            partitionSpec.set(partitionColumn, ptDateTime.replace("-",""));
            Table table = odps.tables().get(tableName);//获取当前表
            boolean a= table.hasPartition(partitionSpec);//判断上述定义分区在表中是否存在
            if(a == false){
                table.createPartition(partitionSpec);
            }
            TableTunnel.UploadSession session = tunnel.createUploadSession(project,tableName,partitionSpec);
            RecordWriter rw = session.openRecordWriter(1);
            Column[] columns = new Column[18];
            columns[0] = new Column("countid", OdpsType.BIGINT);
            columns[1] = new Column("ipaddress", OdpsType.STRING);
            columns[2] = new Column("token", OdpsType.STRING);
            columns[3] = new Column("appkey", OdpsType.STRING);
            columns[4] = new Column("appos", OdpsType.BIGINT);
            columns[5] = new Column("modelname", OdpsType.STRING);
            columns[6] = new Column("modeltype", OdpsType.BIGINT);
            columns[7] = new Column("awardtype", OdpsType.BIGINT);
            columns[8] = new Column("preid", OdpsType.BIGINT);
            columns[9] = new Column("activityid", OdpsType.BIGINT);
            columns[10] = new Column("clicktime", OdpsType.DATETIME);
            columns[11] = new Column("remark", OdpsType.STRING);
            columns[12] = new Column("business", OdpsType.STRING);
            columns[13] = new Column("deviceid", OdpsType.STRING);
            columns[14] = new Column("i", OdpsType.STRING);
            columns[15] = new Column("f", OdpsType.STRING);
            columns[16] = new Column("ua", OdpsType.STRING);
            columns[17] = new Column("countid_new", OdpsType.STRING);

            Record r = new ArrayRecord(columns);
            r.setBigint("countid",null);
            r.setString("ipaddress", countAwradmsgDetail.getIpaddress());
            r.setString("token", countAwradmsgDetail.getToken());
            r.setString("appkey", countAwradmsgDetail.getAppkey());
            r.setBigint("appos", (long)countAwradmsgDetail.getAppos());
            r.setString("modelname", countAwradmsgDetail.getModelname());
            r.setBigint("modeltype", (long)countAwradmsgDetail.getModeltype());
            r.setBigint("awardtype", (long)countAwradmsgDetail.getAwardtype());
            r.setBigint("preid", countAwradmsgDetail.getPreid());
            r.setBigint("activityid", countAwradmsgDetail.getActivityid());
            r.setDatetime("clicktime", countAwradmsgDetail.getClicktime());
            r.setString("remark", countAwradmsgDetail.getRemark());
            r.setString("business", countAwradmsgDetail.getBusiness());
            r.setString("deviceid", countAwradmsgDetail.getDeviceid());
            r.setString("i", countAwradmsgDetail.getI());
            r.setString("f", countAwradmsgDetail.getF());
            r.setString("ua", countAwradmsgDetail.getUa());
            r.setString("countid_new", countAwradmsgDetail.getCountid());
            rw.write(r);
            rw.close();//一定要close，不然无法commit
            Long[] blocks = session.getBlockList();
            session.commit(blocks);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bean
    public Account getAccount(){
        return new AliyunAccount(accessId,accessKey);
    }

    @Bean
    public Odps getOdps(){
        return new Odps(account);
    }
}
