package com.bxm.datapark.service.util;

import com.bxm.datapark.constant.MongoConstant;
import com.bxm.datapark.dal.mongo.ro.CommonRo;
import com.bxm.datapark.dal.mongo.ro.TicketCountHourRo;
import com.bxm.datapark.dal.mongo.vo.*;
import com.bxm.datapark.enums.SumType;
import com.bxm.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.service.util.MongoSomeUtils.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-08 10:35:00
 * @modifier 董朱旭
 * @updated 2018-01-08 10:35:00
 * @description
 */
public class MongoSomeUtils {


    /**
     * 获取比较的时间
     *
     * @param datetime 日期
     * @param hour     小时
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getTime(String datetime, Integer hour) {
        //若参数不正常，直接返回 null
        //返回正确的拼装
        return (StringUtil.isEmpty(datetime) || hour == null) ? null : (datetime + MongoConstant.SPACE + (hour > MongoConstant.NINE ? hour : MongoConstant.ZERO_S + hour) + MongoConstant.HOURTIME);
    }

    /**
     * 获取原始集合数据
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getAwardDetailCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.AWARD_DETAIL + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 获取存储的礼券小时集合名称（券按开发者子链接维度）
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getCountAppHourCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.TICKET_APP_COUNT_HOUR + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 获取存储的礼券小时集合名称（券按开发者维度）
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getCountBusinessHourCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.TICKET_BUSINESS_COUNT_HOUR + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 获取存储的礼券小时集合名称(券维度)
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getCountCertificateHourCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.TICKET_CERTIFICATE_COUNT_HOUR + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 获取存储的礼券维度集合名称
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getCertificateCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.TICKET_COUNT + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 获取存储的开发者维度集合名称
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getAppCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.TICKET_COUNT_APP + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 获取存储的渠道维度集合名称
     *
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getBusinessCollectionName(String datetime) {
        //若参数不正常，直接返回 null
        //返回数据
        return StringUtil.isEmpty(datetime) ? null : MongoConstant.TICKET_COUNT_BUSINESS + datetime.replaceAll(MongoConstant.BAR, MongoConstant.BLANK);
    }

    /**
     * 拼装 key
     *
     * @param first
     * @param last
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String concat(String first, String last) {
        //若参数不正常，直接返回 null
        //返回数据
        return (StringUtil.isEmpty(first) || StringUtil.isEmpty(last)) ? null : first + MongoConstant.COLON + last;
    }


    private static CommonRo getList(CommonRo commonRo, String key, Integer sendPv, Map<String, Integer> mapOpenPv, Map<String, Integer> mapClickPv, Map<String, Integer> mapAvailable) {
        //若是发券量
        commonRo.setSendPv(sendPv != null ? sendPv : MongoConstant.ZERO);

        //看看能不能取到曝光
        Integer openPv = mapOpenPv.get(key);
        commonRo.setOpenPv(openPv != null ? openPv : MongoConstant.ZERO);

        //看看能不能取到点击
        Integer clickPv = mapClickPv.get(key);
        commonRo.setClickPv(clickPv != null ? clickPv : MongoConstant.ZERO);

        //看看能不能取到有效点击
        Integer avaliable = mapAvailable.get(key);
        //有效点击
        commonRo.setValidClick(avaliable != null ? avaliable : MongoConstant.ZERO);

        //有效点击率
        commonRo.setValidClickRate(getConversion(avaliable, clickPv));

        //转换率
        commonRo.setConversion(getConversion(clickPv, openPv));

        //返回结果
        return commonRo;
    }

    /**
     * 礼券维度数据整合
     *
     * @param sendPvs
     * @param mapOpenPv
     * @param mapClickPv
     * @param mapAvailable
     * @return com.bxm.datapark.dal.mongo.ro.CommonRo
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    private static List<CommonRo> dealCertificate(List<AwardDetail> sendPvs, Map<String, Integer> mapOpenPv, Map<String, Integer> mapClickPv, Map<String, Integer> mapAvailable) {
        //声明一个结果集
        List<CommonRo> commonRos = new ArrayList<CommonRo>();

        //遍历试试
        sendPvs
                .stream()
                .filter(detail -> detail.getPreid() != null)
                .forEach(detail -> {
                    //假嘛滴从 map 取一下数据
                    CommonRo commonRo = new CommonRo();
                    commonRo.setCertificateid(detail.getPreid());

                    //放入 集合
                    commonRos.add(getList(commonRo, detail.getPreid().toString(), detail.getCount(), mapOpenPv, mapClickPv, mapAvailable));
                });

        //返回结果
        return commonRos;
    }

    /**
     * 处理开发者维度
     *
     * @param sendPvs
     * @param mapOpenPv
     * @param mapClickPv
     * @param mapAvailable
     * @return void
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    private static List<CommonRo> dealApp(List<AwardDetail> sendPvs, Map<String, Integer> mapOpenPv, Map<String, Integer> mapClickPv, Map<String, Integer> mapAvailable) {

        //声明一个结果集
        List<CommonRo> commonRos = new ArrayList<CommonRo>();

        //遍历试试
        sendPvs
                .stream()
                .filter(detail -> detail.getPreid() != null && detail.getAppkey() != null)
                .forEach(detail -> {
                    //假嘛滴从 map 取一下数据
                    CommonRo commonRo = new CommonRo();
                    commonRo.setCertificateid(detail.getPreid());
                    commonRo.setAppKey(detail.getAppkey());
                    //放入 集合
                    commonRos.add(getList(commonRo, concat(detail.getPreid().toString(), detail.getAppkey()), detail.getCount(), mapOpenPv, mapClickPv, mapAvailable));
                });

        //返回结果
        return commonRos;
    }

    /**
     * 处理子渠道维度
     *
     * @param sendPvs
     * @param mapOpenPv
     * @param mapClickPv
     * @param mapAvailable
     * @return void
     * @author 董朱旭
     * @time 2018/1/8
     * @CopyRight 杭州微财网络科技有限公司
     */
    private static List<CommonRo> dealBusiness(List<AwardDetail> sendPvs, Map<String, Integer> mapOpenPv, Map<String, Integer> mapClickPv, Map<String, Integer> mapAvailable) {
        //声明一个结果集
        List<CommonRo> commonRos = new ArrayList<CommonRo>();
        //遍历试试
        sendPvs
                .stream()
                .filter(detail -> detail.getPreid() != null && detail.getAppkey() != null && detail.getBusiness() != null)
                .forEach(detail -> {
                    //假嘛滴从 map 取一下数据
                    CommonRo commonRo = new CommonRo();
                    commonRo.setCertificateid(detail.getPreid());
                    commonRo.setAppKey(detail.getAppkey());
                    commonRo.setBusiness(detail.getBusiness());
                    //放入 集合
                    commonRos.add(getList(commonRo, concat(concat(detail.getPreid().toString(), detail.getAppkey()), detail.getBusiness()), detail.getCount(), mapOpenPv, mapClickPv, mapAvailable));
                });

        //返回结果
        return commonRos;
    }

    public static List<CommonRo> dealCommonRo(List<AwardDetail> sendPvs, Map<String, Integer> mapOpenPvOld, Map<String, Integer> mapClickPvOld, Map<String, Integer> mapAvailableOld, Integer sumType) {
        //都未空，就不要浪费时间了，兄弟
        if (sendPvs == null) {
            return null;
        }

        //防止频繁的判断
        if (mapAvailableOld == null) {
            mapAvailableOld = new HashMap<String, Integer>(MongoConstant.FOUR);
        }
        if (mapOpenPvOld == null) {
            mapOpenPvOld = new HashMap<String, Integer>(MongoConstant.FOUR);
        }
        if (mapClickPvOld == null) {
            mapClickPvOld = new HashMap<String, Integer>(MongoConstant.FOUR);
        }

        final Map<String, Integer> mapOpenPv = new HashMap<String, Integer>(mapOpenPvOld);
        final Map<String, Integer> mapClickPv = new HashMap<String, Integer>(mapClickPvOld);
        final Map<String, Integer> mapAvailable = new HashMap<String, Integer>(mapAvailableOld);

        //归类进行处理，以便返回

        if (SumType.CERTIFICATE.getCode().equals(sumType)) {
            //礼券维度
            return dealCertificate(sendPvs, mapOpenPv, mapClickPv, mapAvailable);
        } else if (SumType.CERTIFICATE_APP.getCode().equals(sumType)) {
            //开发者维度
            return dealApp(sendPvs, mapOpenPv, mapClickPv, mapAvailable);
        } else if (SumType.CERTIFICATE_APP_BUSINESS.getCode().equals(sumType)) {
            //子渠道维度
            return dealBusiness(sendPvs, mapOpenPv, mapClickPv, mapAvailable);
        }

        //其他情况不考虑
        return null;
    }

      /**
     * 获取转化率和有效点击率
     *
     * @param first
     * @param last
     * @return java.math.BigDecimal
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static BigDecimal getConversion(Integer first, Integer last) {
        if (last == null || MongoConstant.ZERO.equals(last)) {
            return null;
        }
        if (first == null) {
            return new BigDecimal("0");
        }
        return new BigDecimal(first).setScale(MongoConstant.FOUR, BigDecimal.ROUND_HALF_UP).divide(new BigDecimal(last).setScale(MongoConstant.FOUR, BigDecimal.ROUND_HALF_UP), MongoConstant.FOUR);
    }
    /**
     * 获取转化率和有效点击率
     *
     * @param first
     * @param last
     * @return java.math.BigDecimal
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static BigDecimal getConversion(BigDecimal first, Integer last) {
        if (last == null || MongoConstant.ZERO.equals(last)) {
            return null;
        }
        if (first == null) {
            return new BigDecimal("0");
        }
        return first.setScale(MongoConstant.FOUR, BigDecimal.ROUND_HALF_UP).divide(new BigDecimal(last).setScale(MongoConstant.FOUR, BigDecimal.ROUND_HALF_UP), MongoConstant.FOUR);
    }
    /**
     * 获取转化率和有效点击率
     *
     * @param first
     * @param last
     * @return java.math.BigDecimal
     * @author 董朱旭
     * @time 2018/1/9
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static BigDecimal getConversion(Double first, Integer last) {
        if (last == null || MongoConstant.ZERO.equals(last)) {
            return null;
        }
        if (first == null) {
            return new BigDecimal("0");
        }
        return new BigDecimal(first).setScale(MongoConstant.FOUR, BigDecimal.ROUND_HALF_UP).divide(new BigDecimal(last).setScale(MongoConstant.FOUR, BigDecimal.ROUND_HALF_UP), MongoConstant.FOUR);
    }


    /**
     * 获取前一天
     *
     * @param dateTime
     * @return
     */
    public static String getNextDate(String dateTime) {
        return getDate(dateTime, MongoConstant.ONE);
    }

    public static String getPreDate(String dateTime) {
        return getDate(dateTime, MongoConstant.BAR_ONE);
    }

    public static String getDate(String dateTime, Integer amount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(sdf.parse(dateTime));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.add(Calendar.DATE, amount);
        return sdf.format(calendar.getTime());
    }

    /**
     * 获取集合名称（小时维度）
     *
     * @param appkey
     * @param business
     * @param datetime
     * @return java.lang.String
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static String getCollectionName(String appkey, String business, String datetime) {
        if (StringUtil.isEmpty(datetime)) {
            return null;
        }
        //这个是礼券维度
        if (StringUtil.isEmpty(appkey) && StringUtil.isEmpty(business)) {
            return getCountCertificateHourCollectionName(datetime);
        }
        //这个是开发者维度
        if (StringUtil.isNotEmpty(appkey) && StringUtil.isEmpty(business)) {
            return getCountAppHourCollectionName(datetime);
        }
        //这个是渠道维度
        if (StringUtil.isNotEmpty(appkey) && StringUtil.isNotEmpty(business)) {
            return getCountBusinessHourCollectionName(datetime);
        }
        return null;

    }

    /**
     * 获取查询 query
     *
     * @param certificateid
     * @param appkey
     * @param business
     * @param sHour
     * @param eHour
     * @param sortName
     * @param sortType
     * @return org.springframework.data.mongodb.core.query.Query
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static Query getCountHourQuery(Long certificateid,
                                          String appkey,
                                          String business,
                                          Integer sHour,
                                          Integer eHour,
                                          String sortName,
                                          String sortType) {
        Query query = new Query();
        //这个是礼券维度
        if (StringUtil.isEmpty(appkey) && StringUtil.isEmpty(business)) {
            query.addCriteria(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).andOperator(Criteria.where(MongoConstant.HOUR).gte(sHour).lte(eHour)));
        } else
            //这个是开发者维度
            if (StringUtil.isNotEmpty(appkey) && StringUtil.isEmpty(business)) {
                query.addCriteria(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).and(MongoConstant.APPKEY_VO).is(appkey).andOperator(Criteria.where(MongoConstant.HOUR).gte(sHour).lte(eHour)));
            } else
                //这个是渠道维度
                if (StringUtil.isNotEmpty(appkey) && StringUtil.isNotEmpty(business)) {
                    query.addCriteria(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).and(MongoConstant.APPKEY_VO).is(appkey).and(MongoConstant.BUSINESS).is(business).andOperator(Criteria.where(MongoConstant.HOUR).gte(sHour).lte(eHour)));
                }

        //排序方式
        if (MongoConstant.SORT_TYPE_ASC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.ASC, sortName));
        } else if (MongoConstant.SORT_TYPE_DESC.equals(sortType)) {
            query.with(new Sort(Sort.Direction.DESC, sortName));
        }

        return query;
    }

    /**
     * 获取 match （按小时维度）
     *
     * @param certificateid
     * @param appkey
     * @param business
     * @param sHour
     * @param eHour
     * @return org.springframework.data.mongodb.core.aggregation.MatchOperation
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     */
    public static MatchOperation getMatch(Long certificateid,
                                          String appkey,
                                          String business,
                                          Integer sHour,
                                          Integer eHour) {

        //这个是礼券维度
        if (StringUtil.isEmpty(appkey) && StringUtil.isEmpty(business)) {
            return Aggregation.match(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).andOperator(Criteria.where(MongoConstant.HOUR).gte(sHour).lte(eHour)));
        } else
            //这个是开发者维度
            if (StringUtil.isNotEmpty(appkey) && StringUtil.isEmpty(business)) {
                return Aggregation.match(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).and(MongoConstant.APPKEY_VO).is(appkey).andOperator(Criteria.where(MongoConstant.HOUR).gte(sHour).lte(eHour)));
            } else
                //这个是渠道维度
                if (StringUtil.isNotEmpty(appkey) && StringUtil.isNotEmpty(business)) {
                    return Aggregation.match(Criteria.where(MongoConstant.CERTIFICATEID).is(certificateid).and(MongoConstant.APPKEY_VO).is(appkey).and(MongoConstant.BUSINESS).is(business).andOperator(Criteria.where(MongoConstant.HOUR).gte(sHour).lte(eHour)));
                }
        return null;

    }


    /**
     * 获取分组信息（按小时）
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param appkey
     * @param business
     * @return org.springframework.data.mongodb.core.aggregation.GroupOperation
     */
    public static GroupOperation getGroup(String appkey,
                                          String business) {
        //这个是礼券维度
        if (StringUtil.isEmpty(appkey) && StringUtil.isEmpty(business)) {
            return Aggregation
                    .group(Fields.from(Fields.field(MongoConstant.CERTIFICATEID, MongoConstant.CERTIFICATEID)))
                    .sum(MongoConstant.SEND_PV_VO).as(MongoConstant.SEND_PV_VO)
                    .sum(MongoConstant.CLICK_PV_VO).as(MongoConstant.CLICK_PV_VO)
                    .sum(MongoConstant.OPEN_PV_VO).as(MongoConstant.OPEN_PV_VO)
                    .sum(MongoConstant.VALID_CLICK_VO).as(MongoConstant.VALID_CLICK_VO)
                    .sum(MongoConstant.VALID_CLICK_RATE_VO).as(MongoConstant.VALID_CLICK_RATE_VO)
                    .sum(MongoConstant.CONVERSION_VO).as(MongoConstant.CONVERSION_VO);
        } else
        //这个是开发者维度
        if (StringUtil.isNotEmpty(appkey) && StringUtil.isEmpty(business)) {
                return Aggregation
                        .group(Fields.from(Fields.field(MongoConstant.CERTIFICATEID, MongoConstant.CERTIFICATEID))
                        .and(Fields.field(MongoConstant.APPKEY_VO, MongoConstant.APPKEY_VO)))
                        .sum(MongoConstant.SEND_PV_VO).as(MongoConstant.SEND_PV_VO)
                        .sum(MongoConstant.CLICK_PV_VO).as(MongoConstant.CLICK_PV_VO)
                        .sum(MongoConstant.OPEN_PV_VO).as(MongoConstant.OPEN_PV_VO)
                        .sum(MongoConstant.VALID_CLICK_VO).as(MongoConstant.VALID_CLICK_VO)
                        .sum(MongoConstant.VALID_CLICK_RATE_VO).as(MongoConstant.VALID_CLICK_RATE_VO)
                        .sum(MongoConstant.CONVERSION_VO).as(MongoConstant.CONVERSION_VO);

        } else
        //这个是渠道维度
        if (StringUtil.isNotEmpty(appkey) && StringUtil.isNotEmpty(business)) {
            return Aggregation
                    .group(Fields.from(Fields.field(MongoConstant.CERTIFICATEID, MongoConstant.CERTIFICATEID))
                    .and(Fields.field(MongoConstant.APPKEY_VO, MongoConstant.APPKEY_VO))
                    .and(Fields.field(MongoConstant.BUSINESS, MongoConstant.BUSINESS)))
                    .sum(MongoConstant.SEND_PV_VO).as(MongoConstant.SEND_PV_VO)
                    .sum(MongoConstant.CLICK_PV_VO).as(MongoConstant.CLICK_PV_VO)
                    .sum(MongoConstant.OPEN_PV_VO).as(MongoConstant.OPEN_PV_VO)
                    .sum(MongoConstant.VALID_CLICK_VO).as(MongoConstant.VALID_CLICK_VO)
                    .sum(MongoConstant.VALID_CLICK_RATE_VO).as(MongoConstant.VALID_CLICK_RATE_VO)
                    .sum(MongoConstant.CONVERSION_VO).as(MongoConstant.CONVERSION_VO);
        }
        return null;
    }

    /**
     * 数据处理（按小时）
     *
     * @author 董朱旭
     * @time 2018/1/10
     * @CopyRight 杭州微财网络科技有限公司
     * @param countHour
     * @param totalOpenPv
     * @param totalOpenPvPre
     * @param number
     * @return com.bxm.datapark.dal.mongo.ro.TicketCountHourRo
     */
    public static TicketCountHourRo dealOtherThing(TicketCountHour countHour, Integer totalOpenPv,Integer totalOpenPvPre, String number) {
        //声明结果集
        TicketCountHourRo countHourRo=new TicketCountHourRo();
        //复制bean
        BeanUtils.copyProperties(countHour,countHourRo);
        //设置编码
        countHourRo.setNumber(number);
        //时间显示处理
        countHourRo.dealHourShow();
        //发券占比
        Integer openPv=countHour.getOpenPv();
        BigDecimal couponRatio = MongoSomeUtils.getConversion(openPv, totalOpenPv);
        countHourRo.setCouponRatio(couponRatio);
        //发券占比涨幅
        countHourRo.setCouponRatioChange(dealCouponRatioChange(openPv,totalOpenPvPre,countHour.getOpenPvChange(),couponRatio));
        //返回实体
        return countHourRo;
    }

    /**
     * 计算涨幅
     *
     * @author 董朱旭
     * @time 2018/1/15
     * @CopyRight 杭州微财网络科技有限公司
     * @param openPv 今日发券量
     * @param totalOpenPvPre 昨日总发券量
     * @param openChange 发券量涨幅
     * @return java.lang.String
     */
    private static String dealCouponRatioChange(Integer openPv, Integer totalOpenPvPre,String openChange, BigDecimal couponRatio) {
        //若没法计算昨日的发券量
        if(StringUtil.isEmpty(openChange)||MongoConstant.BAR.equals(openChange)||openPv==null||totalOpenPvPre==null||totalOpenPvPre==MongoConstant.ZERO.intValue()){
            return MongoConstant.BAR;
        }
        //计算昨日发券量
        double openPvPre = openPv / (MongoConstant.ONE.intValue() + Double.valueOf(openChange.replaceAll("%", "")) / MongoConstant.ONE_HUNDRED);

        //昨日发券占比计算
        BigDecimal couponRatioPre = MongoSomeUtils.getConversion(openPvPre, totalOpenPvPre);
        //计算发券占比涨幅并返回
        return dealChange(couponRatioPre,couponRatio);
    }

    public static TicketCountHour dealChange(TicketCountHour preData, CommonRo commonRo, Integer hour) {
        //声明结果副集
        TicketCountHour rs=new TicketCountHour();
        //复制 bean
        BeanUtils.copyProperties(commonRo, rs);
        //处理涨幅度
        rs=dealChange(preData,rs);
        //小时设置
        rs.setHour(hour);
        //返回结果
        return rs;
    }
    /**
     * 涨幅度计算
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param preData
     * @param nowData
     * @return com.bxm.datapark.dal.mongo.vo.TicketCountHour
     */
    public static TicketCountHour dealChange(TicketCountHour preData, TicketCountHour nowData) {
        //若未 null
        if(nowData==null){
            return null;
        }
        if(preData==null){
            //发券请求涨幅
            nowData.setSendPvChange("-");
            //曝光量涨幅
            nowData.setOpenPvChange("-");
            //点击量涨幅
            nowData.setClickPvChange("-");
            //有效点击涨幅
            nowData.setValidClickChange("-");
            //有效点击率涨幅
            nowData.setValidClickRateChange("-");
            //转化率涨幅
            nowData.setConversionChange("-");
        }else{
            //发券请求涨幅
            nowData.setSendPvChange(dealChange(preData.getSendPv(),nowData.getSendPv()));
            //曝光量涨幅
            nowData.setOpenPvChange(dealChange(preData.getOpenPv(),nowData.getOpenPv()));
            //点击量涨幅
            nowData.setClickPvChange(dealChange(preData.getClickPv(),nowData.getClickPv()));
            //有效点击涨幅
            nowData.setValidClickChange(dealChange(preData.getValidClick(),nowData.getValidClick()));
            //有效点击率涨幅
            nowData.setValidClickRateChange(dealChange(preData.getValidClickRate(),nowData.getValidClickRate()));
            //转化率涨幅
            nowData.setConversionChange(dealChange(preData.getConversion(),nowData.getConversion()));
        }
        //返回结果
        return nowData;
    
    }
    /**
     * 涨幅度计算
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param preData
     * @param nowData
     * @return com.bxm.datapark.dal.mongo.vo.TicketCount
     */
    public static TicketCount dealChange(TicketCount preData, TicketCount nowData) {
        //若未 null
        if(nowData==null){
            return null;
        }
        if(preData==null){
            //发券请求涨幅
            nowData.setSendPvChange("-");
            //曝光量涨幅
            nowData.setOpenPvChange("-");
            //点击量涨幅
            nowData.setClickPvChange("-");
            //有效点击涨幅
            nowData.setValidClickChange("-");
            //有效点击率涨幅
            nowData.setValidClickRateChange("-");
            //转化率涨幅
            nowData.setConversionChange("-");
        }else{
            //发券请求涨幅
            nowData.setSendPvChange(dealChange(preData.getSendPv(),nowData.getSendPv()));
            //曝光量涨幅
            nowData.setOpenPvChange(dealChange(preData.getOpenPv(),nowData.getOpenPv()));
            //点击量涨幅
            nowData.setClickPvChange(dealChange(preData.getClickPv(),nowData.getClickPv()));
            //有效点击涨幅
            nowData.setValidClickChange(dealChange(preData.getValidClick(),nowData.getValidClick()));
            //有效点击率涨幅
            nowData.setValidClickRateChange(dealChange(preData.getValidClickRate(),nowData.getValidClickRate()));
            //转化率涨幅
            nowData.setConversionChange(dealChange(preData.getConversion(),nowData.getConversion()));
        }
        //返回结果
        return nowData;

    }
    /**
     * 涨幅度计算
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param preData
     * @param nowData
     * @return com.bxm.datapark.dal.mongo.vo.TicketCountApp
     */
    public static TicketCountApp dealChange(TicketCountApp preData, TicketCountApp nowData) {
        //若未 null
        if(nowData==null){
            return null;
        }
        if(preData==null){
            //发券请求涨幅
            nowData.setSendPvChange("-");
            //曝光量涨幅
            nowData.setOpenPvChange("-");
            //点击量涨幅
            nowData.setClickPvChange("-");
            //有效点击涨幅
            nowData.setValidClickChange("-");
            //有效点击率涨幅
            nowData.setValidClickRateChange("-");
            //转化率涨幅
            nowData.setConversionChange("-");
        }else{
            //发券请求涨幅
            nowData.setSendPvChange(dealChange(preData.getSendPv(),nowData.getSendPv()));
            //曝光量涨幅
            nowData.setOpenPvChange(dealChange(preData.getOpenPv(),nowData.getOpenPv()));
            //点击量涨幅
            nowData.setClickPvChange(dealChange(preData.getClickPv(),nowData.getClickPv()));
            //有效点击涨幅
            nowData.setValidClickChange(dealChange(preData.getValidClick(),nowData.getValidClick()));
            //有效点击率涨幅
            nowData.setValidClickRateChange(dealChange(preData.getValidClickRate(),nowData.getValidClickRate()));
            //转化率涨幅
            nowData.setConversionChange(dealChange(preData.getConversion(),nowData.getConversion()));
        }
        //返回结果
        return nowData;

    }
    /**
     * 涨幅度计算
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param preData
     * @param nowData
     * @return com.bxm.datapark.dal.mongo.vo.TicketCountBusiness
     */
    public static TicketCountBusiness dealChange(TicketCountBusiness preData, TicketCountBusiness nowData) {
        //若未 null
        if(nowData==null){
            return null;
        }
        if(preData==null){
            //发券请求涨幅
            nowData.setSendPvChange("-");
            //曝光量涨幅
            nowData.setOpenPvChange("-");
            //点击量涨幅
            nowData.setClickPvChange("-");
            //有效点击涨幅
            nowData.setValidClickChange("-");
            //有效点击率涨幅
            nowData.setValidClickRateChange("-");
            //转化率涨幅
            nowData.setConversionChange("-");
        }else{
            //发券请求涨幅
            nowData.setSendPvChange(dealChange(preData.getSendPv(),nowData.getSendPv()));
            //曝光量涨幅
            nowData.setOpenPvChange(dealChange(preData.getOpenPv(),nowData.getOpenPv()));
            //点击量涨幅
            nowData.setClickPvChange(dealChange(preData.getClickPv(),nowData.getClickPv()));
            //有效点击涨幅
            nowData.setValidClickChange(dealChange(preData.getValidClick(),nowData.getValidClick()));
            //有效点击率涨幅
            nowData.setValidClickRateChange(dealChange(preData.getValidClickRate(),nowData.getValidClickRate()));
            //转化率涨幅
            nowData.setConversionChange(dealChange(preData.getConversion(),nowData.getConversion()));
        }
        //返回结果
        return nowData;

    }
    /**
     * 保留两位小数
     *
     * @param d
     * @return
     */
    public static String formatDouble(Double d) {
        return formatDouble(d, MongoConstant.NUMBER_FOMAT);
    }
    public static String formatDouble(Double d, String fomat) {
        DecimalFormat df = new DecimalFormat(fomat);
        String rs = df.format(d);
        if (rs.indexOf(MongoConstant.BAR) != MongoConstant.BAR_ONE.intValue()) {
            return rs.indexOf(MongoConstant.POINT) == MongoConstant.ONE.intValue() ? rs.replaceFirst(MongoConstant.BAR, MongoConstant.BAR_ZERO_S) : rs;
        } else {
            return rs.indexOf(MongoConstant.POINT) == MongoConstant.ZERO.intValue() ? MongoConstant.ZERO_S + rs : rs;
        }
    }

    /**
     * 计算涨幅度
     *
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param pre
     * @param now
     * @return java.lang.String
     */
    public static String dealChange(Integer pre,Integer now){

        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || MongoConstant.ZERO.equals(pre)) {
            return MongoConstant.BAR;
        }
        return formatDouble((now - pre) * MongoConstant.ONE_HUNDRED / (double) pre) + MongoConstant.SIGN;
    }
    /**
     * 计算涨幅度
     *
     * @author 董朱旭
     * @time 2018/1/12
     * @CopyRight 杭州微财网络科技有限公司
     * @param pre
     * @param now
     * @return java.lang.String
     */
    public static String dealChange(BigDecimal pre,BigDecimal now){
        if (now == null || pre == null || StringUtil.isEmpty(now.toString()) || StringUtil.isEmpty(pre.toString())
                || MongoConstant.ZERO.doubleValue()==pre.doubleValue()) {
            return MongoConstant.BAR;
        }
        return formatDouble((now.doubleValue() - pre.doubleValue()) * MongoConstant.ONE_HUNDRED /  pre.doubleValue()) + MongoConstant.SIGN;
    }
}

