package com.bxm.datapark.service.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    private static final Logger log = LoggerFactory.getLogger(RedisClient.class);

    @Autowired
    private JedisPool jedisPool;

    public void incrRedisWhitDB(String key, Long seconds, Integer dbIndex) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            jedis.incr(key);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            jedis.close();
        }
    }

    public void setWithDB(String key, String value, Long seconds, Integer dbIndex) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            jedis.set(key, value);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        } catch (Exception e) {
            log.error(e.getMessage());
        } finally {
            jedis.close();
        }
    }

    public void pfAdd(String key,String value,Integer dbIndex,Long seconds){
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            jedis.pfadd(key, value);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        } finally {
            // 返还到连接池
            jedis.close();
        }
    }

    /**
     * 存入 set 集合
     */
    public void sAdd(String key,String value,Integer dbIndex,Long seconds){
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex);
            }
            jedis.sadd(key, value);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        } finally {
            // 返还到连接池
            jedis.close();
        }
    }

}
