/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.doris.controller;

import com.bxm.doris.facade.model.AbtestExperimentDataResponse;
import com.bxm.doris.facade.model.DorisDataResponse;
import com.bxm.doris.facade.model.DorisRequest;
import com.bxm.doris.service.DorisService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DorisController {
    private static final Logger log = LoggerFactory.getLogger(DorisController.class);
    @Autowired
    DorisService dorisService;

    @RequestMapping(value={"/getUvByParams"})
    public ResponseEntity<Integer> getUvByParams(@RequestBody DorisRequest dorisRequest) {
        return ResponseEntity.ok((Object)this.dorisService.getUvByParams(dorisRequest));
    }

    @RequestMapping(value={"/getDataByParams"})
    public ResponseEntity<List<DorisDataResponse>> getDataByParams(@RequestBody DorisRequest dorisRequest) {
        return ResponseEntity.ok(this.dorisService.getDataByParams(dorisRequest));
    }

    @GetMapping(value={"/getAbtestExperimentData"})
    ResponseEntity<List<AbtestExperimentDataResponse>> getAbtestExperimentData(@RequestParam(value="experimentId") String experimentId) {
        return ResponseEntity.ok(this.dorisService.getAbtestExperimentData(experimentId));
    }
}

