/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.doris.controller;

import com.bxm.doris.facade.model.EventAnalysisRequest;
import com.bxm.doris.facade.model.HairSumDataResponse;
import com.bxm.doris.facade.model.PositionHairTicketResponse;
import com.bxm.doris.facade.model.PositionPaddingRequest;
import com.bxm.doris.facade.model.PositionPaddingResponse;
import com.bxm.doris.facade.model.PositionTicketGinsengHerbResponse;
import com.bxm.doris.facade.model.TicketGinsengHerbResponse;
import com.bxm.doris.facade.service.EventAnalysisFacadeService;
import com.bxm.doris.service.EventAnalysisService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventAnalysisController
implements EventAnalysisFacadeService {
    private static final Logger log = LoggerFactory.getLogger(EventAnalysisController.class);
    @Autowired
    private EventAnalysisService service;

    @Override
    public ResponseEntity<PositionHairTicketResponse> getPositionHairTicketData(String thedate, String positionId) {
        PositionHairTicketResponse response = this.service.getPositionHairTicketData(thedate, positionId);
        return ResponseEntity.ok((Object)response);
    }

    @Override
    public ResponseEntity<List<PositionHairTicketResponse>> getPositionHairTicketTop10Data(String thedate, String positionId) {
        List<PositionHairTicketResponse> response = this.service.getPositionHairTicketTop10Data(thedate, positionId);
        return ResponseEntity.ok(response);
    }

    @Override
    public ResponseEntity<PositionHairTicketResponse> getTicketIncomeData(String thedate, String positionId, Long ticketId) {
        PositionHairTicketResponse response = this.service.getTicketIncomeData(thedate, positionId, ticketId);
        return ResponseEntity.ok((Object)response);
    }

    @Override
    public ResponseEntity<List<PositionHairTicketResponse>> getTicketIncomeHourData(String thedate, String positionId, Long ticketId) {
        List<PositionHairTicketResponse> response = this.service.getTicketIncomeHourData(thedate, positionId, ticketId);
        return ResponseEntity.ok(response);
    }

    @Override
    public ResponseEntity<List<PositionHairTicketResponse>> getTicketIncomeMinutesData(String thedate, String positionId, Long ticketId) {
        List<PositionHairTicketResponse> response = this.service.getTicketIncomeMinutesData(thedate, positionId, ticketId);
        return ResponseEntity.ok(response);
    }

    @Override
    public ResponseEntity<PositionTicketGinsengHerbResponse> getPositionTicketGinsengHerbInfo(String positionId, String conTicketId, Long anaTicketId, String startHour, String endHour) {
        PositionTicketGinsengHerbResponse response = this.service.getPositionTicketGinsengHerbInfo(positionId, conTicketId, anaTicketId, startHour, endHour);
        return ResponseEntity.ok((Object)response);
    }

    @Override
    public List<TicketGinsengHerbResponse> getDataByParam(@RequestBody EventAnalysisRequest request) {
        List<TicketGinsengHerbResponse> response = this.service.getDataByParam(request);
        return response;
    }

    @Override
    public ResponseEntity<HairSumDataResponse> getPositionHairPv(String positionId, String ticketIds, String startHour, String endHour) {
        HairSumDataResponse positionHairPv = this.service.getPositionHairPv(positionId, Arrays.asList(ticketIds.split(",")), startHour, endHour);
        return ResponseEntity.ok((Object)positionHairPv);
    }

    @Override
    public ResponseEntity<List<PositionPaddingResponse>> getPositionDimensionPadding(@RequestBody PositionPaddingRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getPositionId()) || StringUtils.isBlank((CharSequence)request.getThedate()) || StringUtils.isBlank((CharSequence)request.getThehour())) {
            return ResponseEntity.badRequest().build();
        }
        List<PositionPaddingResponse> responses = this.service.getPositionDimensionPadding(request);
        return ResponseEntity.ok(responses);
    }
}

