/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.doris.service;

import com.bxm.doris.dal.DorisMapper;
import com.bxm.doris.facade.enums.AppsEnum;
import com.bxm.doris.facade.enums.ISPEnum;
import com.bxm.doris.facade.enums.OSSEnum;
import com.bxm.doris.facade.model.AbtestExperimentDataResponse;
import com.bxm.doris.facade.model.DorisDataResponse;
import com.bxm.doris.facade.model.DorisRequest;
import com.bxm.doris.model.DorisRequestSearch;
import com.bxm.doris.util.Province;
import com.bxm.warcar.utils.DateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.stereotype.Service;

@Service
public class DorisService {
    @Resource
    DorisMapper dorisMapper;

    public Integer getUvByParams(DorisRequest dorisRequest) {
        DorisRequestSearch dorisRequestSearch = this.covert(dorisRequest);
        return this.dorisMapper.getUvByParams(dorisRequestSearch);
    }

    public List<DorisDataResponse> getDataByParams(DorisRequest dorisRequest) {
        DorisRequestSearch dorisRequestSearch = this.covert(dorisRequest);
        return this.dorisMapper.getDataByParams(dorisRequestSearch);
    }

    private DorisRequestSearch covert(DorisRequest dorisRequest) {
        String oss;
        ArrayList<String> finalList;
        DorisRequestSearch dorisRequestSearch = new DorisRequestSearch();
        dorisRequestSearch.setPositionId(dorisRequest.getPositionId());
        dorisRequestSearch.setLimit(dorisRequest.getLimit());
        dorisRequestSearch.setStartTime(dorisRequest.getStartTime());
        dorisRequestSearch.setEndTime(dorisRequest.getEndTime());
        dorisRequestSearch.setAppkey(dorisRequest.getPositionId().split("-")[0]);
        dorisRequestSearch.setBusiness("money-" + dorisRequest.getPositionId().split("-")[1]);
        dorisRequestSearch.setPt(DateHelper.format((Date)DateHelper.parse((String)dorisRequest.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyyMMdd"));
        if (Objects.nonNull((Object)dorisRequest.getDimensionNameEnum())) {
            dorisRequestSearch.setDimensionName(dorisRequest.getDimensionNameEnum().getName());
        }
        dorisRequestSearch.setTicketId(dorisRequest.getTicketId());
        if (!StringUtil.isBlank((String)dorisRequest.getCitys())) {
            List<String> citysCodeList = Arrays.asList(dorisRequest.getCitys().split(","));
            ArrayList<String> citysList = new ArrayList<String>();
            for (String value : citysCodeList) {
                String city = Province.map.get(value);
                if (StringUtil.isBlank((String)city)) continue;
                citysList.add(city);
            }
            if (!CollectionUtils.isEmpty(citysList)) {
                dorisRequestSearch.setCitysList(citysList);
            }
        }
        if (!StringUtil.isBlank((String)dorisRequest.getApps())) {
            List<String> appsList = Arrays.asList(dorisRequest.getApps().split(","));
            finalList = new ArrayList<String>();
            for (String value : appsList) {
                String app = AppsEnum.findDescByName(value).getDesc();
                if (StringUtil.isBlank((String)app)) continue;
                finalList.add(app);
            }
            if (!CollectionUtils.isEmpty(finalList)) {
                dorisRequestSearch.setAppsList(finalList);
            }
        }
        if (!StringUtil.isBlank((String)dorisRequest.getOss())) {
            List<String> ossList = Arrays.asList(dorisRequest.getOss().split(","));
            finalList = new ArrayList();
            for (String value : ossList) {
                oss = OSSEnum.findDescByName(value).getDesc();
                if (StringUtil.isBlank((String)oss)) continue;
                finalList.add(oss);
            }
            if (!CollectionUtils.isEmpty(finalList)) {
                dorisRequestSearch.setOssList(finalList);
            }
        }
        if (!StringUtil.isBlank((String)dorisRequest.getIspDomain())) {
            List<String> ispList = Arrays.asList(dorisRequest.getIspDomain().split(","));
            finalList = new ArrayList();
            for (String value : ispList) {
                oss = ISPEnum.findDescByName(value).getDesc();
                if (StringUtil.isBlank((String)oss)) continue;
                finalList.add(oss);
            }
            if (!CollectionUtils.isEmpty(finalList)) {
                dorisRequestSearch.setIspList(finalList);
            }
        }
        return dorisRequestSearch;
    }

    public List<AbtestExperimentDataResponse> getAbtestExperimentData(String experimentId) {
        return this.dorisMapper.getAbtestExperimentData(experimentId);
    }
}

