/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.doris.service;

import com.bxm.doris.dal.DorisMapper;
import com.bxm.doris.dal.EventAnalysisMapper;
import com.bxm.doris.facade.model.EventAnalysisRequest;
import com.bxm.doris.facade.model.HairSumDataResponse;
import com.bxm.doris.facade.model.PositionHairTicketResponse;
import com.bxm.doris.facade.model.PositionPaddingRequest;
import com.bxm.doris.facade.model.PositionPaddingResponse;
import com.bxm.doris.facade.model.PositionTicketGinsengHerbResponse;
import com.bxm.doris.facade.model.TicketDimensionResponse;
import com.bxm.doris.facade.model.TicketGinsengHerbResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EventAnalysisService {
    @Resource
    DorisMapper dorisMapper;
    @Resource
    EventAnalysisMapper eventAnalysisMapper;

    public PositionHairTicketResponse getPositionHairTicketData(String thedate, String positionId) {
        if (StringUtils.isBlank((CharSequence)thedate) || StringUtils.isBlank((CharSequence)positionId)) {
            throw new IllegalArgumentException();
        }
        PositionHairTicketResponse positionHairTicketData = this.dorisMapper.getPositionHairTicketData(thedate, positionId);
        return positionHairTicketData;
    }

    public List<PositionHairTicketResponse> getPositionHairTicketTop10Data(String thedate, String positionId) {
        if (StringUtils.isBlank((CharSequence)thedate) || StringUtils.isBlank((CharSequence)positionId)) {
            throw new IllegalArgumentException();
        }
        List<PositionHairTicketResponse> positionHairTicketTop10Data = this.dorisMapper.getPositionHairTicketTop10Data(thedate, positionId);
        return positionHairTicketTop10Data;
    }

    public PositionHairTicketResponse getTicketIncomeData(String thedate, String positionId, Long ticketId) {
        if (StringUtils.isBlank((CharSequence)thedate) || ticketId == null) {
            throw new IllegalArgumentException();
        }
        PositionHairTicketResponse ticketIncomeData = this.dorisMapper.getTicketIncomeData(thedate, positionId, ticketId);
        return ticketIncomeData;
    }

    public List<PositionHairTicketResponse> getTicketIncomeHourData(String thedate, String positionId, Long ticketId) {
        if (StringUtils.isBlank((CharSequence)thedate) || ticketId == null || StringUtils.isBlank((CharSequence)positionId)) {
            throw new IllegalArgumentException();
        }
        List<PositionHairTicketResponse> ticketIncomeData = this.dorisMapper.getTicketIncomeHourData(thedate, positionId, ticketId);
        return ticketIncomeData;
    }

    public List<PositionHairTicketResponse> getTicketIncomeMinutesData(String thedate, String positionId, Long ticketId) {
        if (StringUtils.isBlank((CharSequence)thedate) || ticketId == null || StringUtils.isBlank((CharSequence)positionId)) {
            throw new IllegalArgumentException();
        }
        String hour = thedate.substring(thedate.length() - 2);
        String date = thedate.substring(0, thedate.length() - 2);
        List<PositionHairTicketResponse> ticketIncomeData = this.dorisMapper.getTicketIncomeMinutesData(date, hour, positionId, ticketId);
        return ticketIncomeData;
    }

    public PositionTicketGinsengHerbResponse getPositionTicketGinsengHerbInfo(String positionId, String conTicketId, Long anaTicketId, String startHour, String endHour) {
        String[] split = conTicketId.split(",");
        List<String> conTicketIds = Arrays.asList(split);
        List<TicketGinsengHerbResponse> ticketHoursBidData = this.dorisMapper.getTicketHoursBidData(positionId, conTicketIds, anaTicketId, startHour, endHour);
        List<TicketDimensionResponse> ticketHoursBidDimensionData = this.dorisMapper.getTicketHoursBidDimensionData(positionId, conTicketIds, anaTicketId, startHour, endHour);
        List<TicketDimensionResponse> thehourDimensionData = this.dorisMapper.getTicketDimensionData(positionId, conTicketIds, anaTicketId, startHour, endHour, "thehour");
        List<TicketDimensionResponse> appOsDimensionData = this.dorisMapper.getTicketDimensionData(positionId, conTicketIds, anaTicketId, startHour, endHour, "app_os");
        List<TicketDimensionResponse> payEvnDimensionData = this.dorisMapper.getTicketDimensionData(positionId, conTicketIds, anaTicketId, startHour, endHour, "pay_env");
        List<TicketDimensionResponse> ispDomainDimensionData = this.dorisMapper.getTicketDimensionData(positionId, conTicketIds, anaTicketId, startHour, endHour, "isp_domain");
        List<TicketDimensionResponse> provinceDimensionData = this.dorisMapper.getTicketDimensionTop10Data(positionId, conTicketIds, anaTicketId, startHour, endHour, "province");
        List<TicketDimensionResponse> cityDimensionData = this.dorisMapper.getTicketDimensionTop10Data(positionId, conTicketIds, anaTicketId, startHour, endHour, "city");
        TicketDimensionResponse conData1 = new TicketDimensionResponse();
        TicketDimensionResponse conData2 = new TicketDimensionResponse();
        TicketDimensionResponse anaData = new TicketDimensionResponse();
        this.mergeData(ticketHoursBidDimensionData, thehourDimensionData, appOsDimensionData, payEvnDimensionData, ispDomainDimensionData, provinceDimensionData, cityDimensionData, conData1, conData2, anaData, conTicketIds, anaTicketId);
        PositionTicketGinsengHerbResponse response = new PositionTicketGinsengHerbResponse();
        response.setGinsengHer(ticketHoursBidData);
        ArrayList<TicketDimensionResponse> ticketDimensionResponses = new ArrayList<TicketDimensionResponse>(2);
        ticketDimensionResponses.add(anaData);
        ticketDimensionResponses.add(conData1);
        ticketDimensionResponses.add(conData2);
        response.setSummaryAnalysis(ticketDimensionResponses);
        return response;
    }

    private void mergeData(List<TicketDimensionResponse> ticketHoursBidDimensionData, List<TicketDimensionResponse> thehourDimensionData, List<TicketDimensionResponse> appOsDimensionData, List<TicketDimensionResponse> payEvnDimensionData, List<TicketDimensionResponse> ispDomainDimensionData, List<TicketDimensionResponse> provinceDimensionData, List<TicketDimensionResponse> cityDimensionData, TicketDimensionResponse conData1, TicketDimensionResponse conData2, TicketDimensionResponse anaData, List<String> conTicketIds, Long anaTicketId) {
        Integer anaHour;
        Long conTicketId1 = Long.valueOf(conTicketIds.get(0));
        Long conTicketId2 = null;
        if (conTicketIds.size() > 1) {
            conTicketId2 = Long.valueOf(conTicketIds.get(1));
        }
        conData1.setTicketId(conTicketId1);
        conData2.setTicketId(conTicketId2);
        anaData.setTicketId(anaTicketId);
        Map ticketHoursBidDimensionMap = ticketHoursBidDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1TicketHoursBidDimension = ticketHoursBidDimensionMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2TicketHoursBidDimension = ticketHoursBidDimensionMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        conData1.setHours(con1TicketHoursBidDimension.getHours());
        conData2.setHours(con2TicketHoursBidDimension.getHours());
        conData1.setSequenceDimension(new TicketDimensionResponse.DimensionData(con1TicketHoursBidDimension.getBidPv(), con1TicketHoursBidDimension.getIncomeArpu(), con1TicketHoursBidDimension.getClickAvgPrice()));
        conData2.setSequenceDimension(new TicketDimensionResponse.DimensionData(con2TicketHoursBidDimension.getBidPv(), con2TicketHoursBidDimension.getIncomeArpu(), con2TicketHoursBidDimension.getClickAvgPrice()));
        TicketDimensionResponse anaTicketHoursBidDimension = ticketHoursBidDimensionMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        anaData.setHours(anaTicketHoursBidDimension.getHours());
        anaData.setSequenceDimension(new TicketDimensionResponse.DimensionData(anaTicketHoursBidDimension.getBidPv(), anaTicketHoursBidDimension.getIncomeArpu(), anaTicketHoursBidDimension.getClickAvgPrice()));
        Map thehourDimensionMap = thehourDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1Thehour = thehourDimensionMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2Thehour = thehourDimensionMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        String thehourCon1 = con1Thehour.getDimension();
        String thehourCon2 = con2Thehour.getDimension();
        Integer con1Hour = thehourCon1 == null ? null : Integer.valueOf(thehourCon1.substring(thehourCon1.length() - 2));
        Integer con2Hour = thehourCon2 == null ? null : Integer.valueOf(thehourCon2.substring(thehourCon2.length() - 2));
        conData1.setHourDimension(new TicketDimensionResponse.DimensionData(con1Thehour.getBidPv(), con1Thehour.getIncomeArpu(), con1Thehour.getClickAvgPrice()));
        conData2.setHourDimension(new TicketDimensionResponse.DimensionData(con2Thehour.getBidPv(), con2Thehour.getIncomeArpu(), con2Thehour.getClickAvgPrice()));
        TicketDimensionResponse anaThehour = thehourDimensionMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        String thehourAna = anaThehour.getDimension();
        Integer n = anaHour = thehourAna == null ? null : Integer.valueOf(thehourAna.substring(thehourAna.length() - 2));
        anaData.setHour(anaHour == null ? (con1Hour == null ? con2Hour : con1Hour) : anaHour);
        anaData.setHourDimension(new TicketDimensionResponse.DimensionData(anaThehour.getBidPv(), anaThehour.getIncomeArpu(), anaThehour.getClickAvgPrice()));
        Map appOsDimensionMap = appOsDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1AppOs = appOsDimensionMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2AppOs = appOsDimensionMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        String con1AppOsDimension = con1AppOs.getDimension();
        String con2AppOsDimension = con2AppOs.getDimension();
        conData1.setAppOsDimension(new TicketDimensionResponse.DimensionData(con1AppOs.getBidPv(), con1AppOs.getIncomeArpu(), con1AppOs.getClickAvgPrice()));
        conData2.setAppOsDimension(new TicketDimensionResponse.DimensionData(con2AppOs.getBidPv(), con2AppOs.getIncomeArpu(), con2AppOs.getClickAvgPrice()));
        TicketDimensionResponse anaAppOs = appOsDimensionMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        String anaAppOsDimension = anaAppOs.getDimension();
        anaData.setAppOs(StringUtils.isBlank((CharSequence)anaAppOsDimension) ? (StringUtils.isBlank((CharSequence)con1AppOsDimension) ? con2AppOsDimension : con1AppOsDimension) : anaAppOsDimension);
        anaData.setAppOsDimension(new TicketDimensionResponse.DimensionData(anaAppOs.getBidPv(), anaAppOs.getIncomeArpu(), anaAppOs.getClickAvgPrice()));
        Map payEvnMap = payEvnDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1PayEvn = payEvnMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2PayEvn = payEvnMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        String con1PayEvnDimension = con1PayEvn.getDimension();
        String con2PayEvnDimension = con2PayEvn.getDimension();
        conData1.setPayEnvDimension(new TicketDimensionResponse.DimensionData(con1PayEvn.getBidPv(), con1PayEvn.getIncomeArpu(), con1PayEvn.getClickAvgPrice()));
        conData2.setPayEnvDimension(new TicketDimensionResponse.DimensionData(con2PayEvn.getBidPv(), con2PayEvn.getIncomeArpu(), con2PayEvn.getClickAvgPrice()));
        TicketDimensionResponse anaPayEvn = payEvnMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        String anaPayEvnDimension = anaPayEvn.getDimension();
        anaData.setPayEnv(StringUtils.isBlank((CharSequence)anaPayEvnDimension) ? (StringUtils.isBlank((CharSequence)con1PayEvnDimension) ? con2PayEvnDimension : con1PayEvnDimension) : anaPayEvnDimension);
        anaData.setPayEnvDimension(new TicketDimensionResponse.DimensionData(anaPayEvn.getBidPv(), anaPayEvn.getIncomeArpu(), anaPayEvn.getClickAvgPrice()));
        Map ispDomainMap = ispDomainDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1IspDomain = ispDomainMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2IspDomain = ispDomainMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        String con1IspDomainDimension = con1IspDomain.getDimension();
        String con2IspDomainDimension = con2IspDomain.getDimension();
        conData1.setIspDomainDimension(new TicketDimensionResponse.DimensionData(con1IspDomain.getBidPv(), con1IspDomain.getIncomeArpu(), con1IspDomain.getClickAvgPrice()));
        conData2.setIspDomainDimension(new TicketDimensionResponse.DimensionData(con2IspDomain.getBidPv(), con2IspDomain.getIncomeArpu(), con2IspDomain.getClickAvgPrice()));
        TicketDimensionResponse anaIspDomain = ispDomainMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        String anaIspDomainDimension = anaIspDomain.getDimension();
        anaData.setIspDomain(StringUtils.isBlank((CharSequence)anaIspDomainDimension) ? (StringUtils.isBlank((CharSequence)con1IspDomainDimension) ? con2IspDomainDimension : con1IspDomainDimension) : anaIspDomainDimension);
        anaData.setIspDomainDimension(new TicketDimensionResponse.DimensionData(anaIspDomain.getBidPv(), anaIspDomain.getIncomeArpu(), anaIspDomain.getClickAvgPrice()));
        Map provinceMap = provinceDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1Province = provinceMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2Province = provinceMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        conData1.setProvinceDimension(new TicketDimensionResponse.DimensionData(con1Province.getBidPv(), con1Province.getIncomeArpu(), con1Province.getClickAvgPrice()));
        conData2.setProvinceDimension(new TicketDimensionResponse.DimensionData(con2Province.getBidPv(), con2Province.getIncomeArpu(), con2Province.getClickAvgPrice()));
        TicketDimensionResponse anaProvince = provinceMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        anaData.setProvinceDimension(new TicketDimensionResponse.DimensionData(anaProvince.getBidPv(), anaProvince.getIncomeArpu(), anaProvince.getClickAvgPrice()));
        Map cityMap = cityDimensionData.stream().collect(Collectors.toMap(TicketDimensionResponse::getTicketId, Function.identity()));
        TicketDimensionResponse con1City = cityMap.getOrDefault(conTicketId1, new TicketDimensionResponse());
        TicketDimensionResponse con2City = cityMap.getOrDefault(conTicketId2, new TicketDimensionResponse());
        conData1.setCityDimension(new TicketDimensionResponse.DimensionData(con1City.getBidPv(), con1City.getIncomeArpu(), con1City.getClickAvgPrice()));
        conData2.setCityDimension(new TicketDimensionResponse.DimensionData(con2City.getBidPv(), con2City.getIncomeArpu(), con2City.getClickAvgPrice()));
        TicketDimensionResponse anaCity = cityMap.getOrDefault(anaTicketId, new TicketDimensionResponse());
        anaData.setCityDimension(new TicketDimensionResponse.DimensionData(anaCity.getBidPv(), anaCity.getIncomeArpu(), anaCity.getClickAvgPrice()));
    }

    public List<TicketGinsengHerbResponse> getDataByParam(EventAnalysisRequest request) {
        List<TicketGinsengHerbResponse> dataByParam = this.dorisMapper.getDataByParam(request.getIsThehour(), request.getIsSequence(), request.getIsRegion(), request.getIsAppOs(), request.getIsPayEvn(), request.getIsIspDomain(), request.getPositionId(), Arrays.asList(request.getConTicketId().split(",")), request.getAnaTicketId(), request.getStartHour(), request.getEndHour(), request.getProvinces(), request.getCitys(), request.getAppOss(), request.getSequences(), request.getPayEvns(), request.getIspDomains(), request.getThehours());
        return dataByParam;
    }

    public HairSumDataResponse getPositionHairPv(String positionId, List<String> ticketIds, String startHour, String endHour) {
        List<TicketGinsengHerbResponse> sumData = this.dorisMapper.getSumData(positionId, ticketIds, startHour, endHour);
        List<String> province = this.dorisMapper.getProCity(positionId, ticketIds, startHour, endHour, "province");
        List<String> city = this.dorisMapper.getProCity(positionId, ticketIds, startHour, endHour, "city");
        int positionHairPv = this.dorisMapper.getPositionHairPv(positionId, startHour, endHour);
        List<TicketGinsengHerbResponse> ticketName = this.dorisMapper.getTicketName(ticketIds);
        Map<Long, String> collect = ticketName.stream().collect(Collectors.toMap(TicketGinsengHerbResponse::getTicketId, TicketGinsengHerbResponse::getTicketName));
        HairSumDataResponse hairSumDataResponse = new HairSumDataResponse(sumData, province, city, positionHairPv, collect);
        return hairSumDataResponse;
    }

    public List<PositionPaddingResponse> getPositionDimensionPadding(PositionPaddingRequest request) {
        List<PositionPaddingResponse> ticketList = this.eventAnalysisMapper.getPositionDimensionTicketData(request);
        List<PositionPaddingResponse> standbyList = this.eventAnalysisMapper.getPositionDimensionStandbyTicketData(request);
        if (request.isAppOsDimension()) {
            this.fixOsDimension(ticketList, standbyList);
        }
        HashMap<String, PositionPaddingResponse> mergedMap = new HashMap<String, PositionPaddingResponse>();
        for (PositionPaddingResponse response : ticketList) {
            mergedMap.put(response.getDimension(), response);
        }
        for (PositionPaddingResponse response : standbyList) {
            String dimension = response.getDimension();
            PositionPaddingResponse mergedResponse = mergedMap.getOrDefault(dimension, new PositionPaddingResponse());
            mergedResponse.setDimension(dimension);
            mergedResponse.setTodayStandbyOpenPv(response.getTodayStandbyOpenPv());
            mergedResponse.setHourStandbyOpenPv(response.getHourStandbyOpenPv());
            mergedMap.put(dimension, mergedResponse);
        }
        ArrayList<PositionPaddingResponse> mergedList = new ArrayList<PositionPaddingResponse>(mergedMap.values());
        return mergedList;
    }

    private void fixOsDimension(List<PositionPaddingResponse> ticketList, List<PositionPaddingResponse> standbyList) {
        ticketList.forEach(response -> {
            if (Objects.equals(response.getDimension(), "WEB")) {
                response.setDimension("\u5176\u4ed6");
            }
        });
        standbyList.forEach(response -> {
            if (Objects.equals(response.getDimension(), "WEB")) {
                response.setDimension("\u5176\u4ed6");
            }
        });
    }
}

