#!/bin/bash

ACTIVE="$1"
if [ -z "$ACTIVE" ]; then
  ACTIVE="test"
  echo "Use default profile: $ACTIVE"
fi

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/doris-api.pid ]; then
  echo "Server [doris-api] pid file has been exists!";
  exit
fi


HEAP_MEMORY=512m
SERVER_JAR=`ls ../lib/doris-api-1.0.2.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms${HEAP_MEMORY} -Xmx${HEAP_MEMORY} -XX:+HeapDumpOnOutOfMemoryError -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=3333 -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/doris-api.pid