#!/bin/bash

if [ ! -f ~/run/doris-api.pid ]; then
  echo "Server [doris-api] doest not started!"
  exit
fi

pid=`cat ~/run/doris-api.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in doris-api.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [doris-api] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [doris-api] cannot stop, Please check pid file 'doris-api.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [doris-api] has been stoped!"
fi

rm -f ~/run/doris-api.pid