package com.bxm.doris.facade.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auth lijingyu
 * 广告位发券收益结果
 */
@Data
public class PositionHairTicketResponse implements Serializable {

    private static final long serialVersionUID = 81435425486643906L;

    /**
     * 日期
     */
    private String thedate;

    /**
     * ctr 点击/曝光
     */
    private BigDecimal ctr;

    /**
     * cvr 有效点击量/点击
     */
    private BigDecimal cvr;

    /**
     * 收入发券arpu
     */
    private BigDecimal incomeArpu;

    /**
     * 券收入
     */
    private BigDecimal income;

    /**
     * 点击均价
     * 消耗/点击
     */
    private BigDecimal clickCost;

    /**
     * 填充数
     * 广告位填充的广告券数量
     */
    private Integer fillNum;

    /**
     * 核心填充行业
     * 广告位券曝光最多的行业
     */
    private String industry;

    /**
     * 券ID
     */
    private Long ticketId;

    private String ticketName;
    private String aeName;

    /**
     * 一级行业
     */
    private String ticketTag;

    /**
     * 二级行业
     */
    private String ticketTagSecond;

    /**
     * 曝光
     */
    private Integer openPv;

    /**
     * 点击
     */
    private Integer clickPv;

    /**
     * 有效点击量
     */
    private Integer validClickPv;

    /**
     * 消耗
     */
    private BigDecimal consume;

    /**
     * 广告位曝光最多的券ID
     */
    private Long maxOpenPvTicketId;

}
