package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.monitor.FacadeDmAdAlarmDataMinutely;
import com.bxm.doris.facade.model.monitor.FacadeRtbValidateCost;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author daill
 * @date 2023/12/13
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface AlarmDataMinutelyFacadeService {

    // rtb
    @RequestMapping(value = "/findR")
    List<FacadeDmAdAlarmDataMinutely> findR(@RequestParam("startTime") String startTime,
                                            @RequestParam("endTime") String endTime);

    //rtb+ticket
    @RequestMapping(value = "/findRT")
    List<FacadeDmAdAlarmDataMinutely> findRT(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //rtb+ticket+position
    @RequestMapping(value = "/findRTP")
    List<FacadeDmAdAlarmDataMinutely> findRTP(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //rtb+ticket+appkey
    @RequestMapping(value = "/findRTA")
    List<FacadeDmAdAlarmDataMinutely> findRTA(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //rtb+position
    @RequestMapping(value = "/findRP")
    List<FacadeDmAdAlarmDataMinutely> findRP(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //rtb+appkey
    @RequestMapping(value = "/findRA")
    List<FacadeDmAdAlarmDataMinutely> findRA(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);


    //ticket
    @RequestMapping(value = "/findT")
    List<FacadeDmAdAlarmDataMinutely> findT(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //appkey
    @RequestMapping(value = "/findA")
    List<FacadeDmAdAlarmDataMinutely> findA(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //position
    @RequestMapping(value = "/findP")
    List<FacadeDmAdAlarmDataMinutely> findP(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //ticket+appkey
    @RequestMapping(value = "/findTA")
    List<FacadeDmAdAlarmDataMinutely> findTA(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    //ticket+position
    @RequestMapping(value = "/findTP")
    List<FacadeDmAdAlarmDataMinutely> findTP(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);


    /**
     * 获取广告位当前小时成本
     *
     * @return
     */
    @RequestMapping(value = "/findHourOcpcCost")
    List<FacadeRtbValidateCost> findHourOcpcCost(@RequestParam("dateTime") String dateTime,@RequestParam("hour") Integer hour);

}
