package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.FacadeSearchDataCommon;
import com.bxm.doris.facade.model.datapark.TicketData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface TicketPositionFacadeService {

    /**
     * 查找券广告位数据
     * @param search
     * @return
     */
    @RequestMapping("/data/ticket/position")
    List<TicketData> getTicketPositionData(@RequestBody FacadeSearchDataCommon search);


}
