package com.bxm.doris.facade.enums;


import org.springframework.util.StringUtils;

/**
 * @author 拉拉
 * @version v1.0.0
 * @created 2023-8-09 13:49:00
 */
public enum OSSEnum {

    /**
     * 运营后台    1:android, 2:ios, 4:其他
     * doris环境: 操作系统: 1:安卓, 2:ios, 3:web, 4:其他
     */
    OSS_ANDROID("1","1"),
    OSS_IOS("2","2"),
    OSS_OTHER("4","3");

    private String name;

    private String desc;


    OSSEnum(String name, String desc) {
        this.desc = desc;
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static OSSEnum findDescByName(String name) {
        for (OSSEnum r : values()) {
            if (StringUtils.endsWithIgnoreCase(name, r.name)) {
                return r;
            }
        }
        return null;
    }

}
