package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.AdApiMaterialDataResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface AdApiMaterialFacadeService {


    /**
     * 根据素材id和广告为id查询
     * @param dateTime 时间
     * @param materialId 素材id
     * @param positionId 广告位id
     * @return 数据
     */
    @GetMapping("/adApiMaterial/selectByAssetIdAndPosId")
    AdApiMaterialDataResponse selectByAssetIdAndPosId(@RequestParam("dateTime") String dateTime,
                                                      @RequestParam("materialId") Long materialId,
                                                      @RequestParam("positionId") String positionId);

    /**
     * 查询防封信息
     * @param dateTime 时间
     * @param antiSealing 是否防封
     * @return 数据
     */
    @GetMapping("/adApiMaterial/selectByDateAndAntiSeal")
    List<AdApiMaterialDataResponse> selectByDateAndAntiSeal(@RequestParam("dateTime") String dateTime,
                                                            @RequestParam("antiSealing") String antiSealing);

    /**
     * 根据日期查询数据
     * @param dateTime 时间
     * @return 数据
     */
    @GetMapping("/adApiMaterial/selectByDate")
    List<AdApiMaterialDataResponse> selectByDate(@RequestParam("dateTime") String dateTime);



}
