package com.bxm.doris.facade.enums;


import org.springframework.util.StringUtils;

/**
 * @author 拉拉
 * @version v1.0.0
 * @created 2023-8-09 13:49:00
 */
public enum AppsEnum {
    /**
     * 运营后台    1:微信, 2:支付宝, 5:其他
     * doris环境: 1:微信, 2:支付宝, 0:其他
     */
    UA_WECHAT("1", "1"),
    UA_ALIPAY("2", "2"),
    UA_OTHER("5", "0");


    private String name;

    private String desc;


    AppsEnum(String name, String desc) {
        this.desc = desc;
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static AppsEnum findDescByName(String name) {
        for (AppsEnum r : values()) {
            if (StringUtils.endsWithIgnoreCase(name, r.name)) {
                return r;
            }
        }
        return null;
    }

}
