package com.bxm.doris.facade.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 
 *
 * @author pf.w
 * @since 2023-09-05
 */
@Data
public class CreativeReviewResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 素材名
     */
    private String name;

    /**
     * 创意标题
     */
    private String title;

    /**
     * 描述
     */
    private String content;

    /**
     * 创意类型:TEXT_ICON—图文混合广告，VIDEO—视频广告
     */
    private String type;

    /**
     * 目标投放平台:ANDROID：安卓,IOS：ios, GENERAL：通投, OTHER_PLATFORM：其他平台
     */
    private String targetPlatform;

    /**
     * 素材地址
     */
    private String materialUrl;

    /**
     * 视频封面url
     */
    private String coverUrl;

    /**
     * 素材高度
     */
    private Integer height;

    /**
     * 素材宽度
     */
    private Integer weight;

    /**
     * clickUrl
     */
    private String clickUrl;

    /**
     * depLinkUrl
     */
    private String deepLinkUrl;

    /**
     * 平台ID
     */
    private Long dspId;
    private String dspName;

    /**
     * 审核状态0：未提审1：提审中2：拒绝3：审核通过
     */
    private Integer status;

    /**
     * 提审媒体
     * @see com.bxm.mccms.facade.enums.CreativeReviewEnum.Media
     */
    private String media;

    /**
     * 审核状态描述
     */
    private String msg;

    private String ext;

    private LocalDateTime modifyTime;

    /**
     * 广告类型
     *
     */
    private String adType;

    /**
     * 广告位类型
     * @see com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum
     */
    private String positionType;

    /**
     * 是否被关联
     */
    private Integer isBind;

    private BigDecimal rate;

    /**
     * 图片地址 creativeType是TEXT_ICON时必填
     */
    private String imgUrl;

    /**
     * 图片高度
     */
    private Integer imgHeight;

    /**
     * 图片宽度
     */
    private Integer imgWeight;

    /**
     * 视频链接 creativeType是VIDEO/VERTICAL_SCREEN/HORIZONTAL_SCREEN时必填
     */
    private String videoUrl;

    /**
     * 视频高度
     */
    private Integer videoHeight;

    /**
     * 视频宽度
     */
    private Integer videoWeight;

    /**
     * 应用icon url creativeType = STICKER时 必填 要求比例1:1, 大于156像素, 图片小于100K(含)
     */
    private String iconUrl;

    /**
     * 应用icon
     */
    private Integer iconHeight;

    /**
     * 应用icon
     */
    private Integer iconWeight;

    /**
     * 曝光数
     */
    private Integer expourseNum;

    /**
     * 点击数
     */
    private Integer clickNum;

    private String dspAppId;
    private String dspTagId;
    private String createId;
    private String sspTagId;
}
