package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.AdxPositionRequest;
import com.bxm.doris.facade.model.AdxPositionResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * Adx广告位维度
 *
 * @author fgf
 * @date 2023/12/20
 **/
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface AdxPositionFacadeService {

    /**
     * 查询adx广告位的统计信息
     *
     * @param adxPositionRequest
     * @return
     */
    @RequestMapping("/getAdxPositionStatistics")
    ResponseEntity<List<AdxPositionResponse>> getAdxPositionStatistics(@RequestBody AdxPositionRequest adxPositionRequest);
}
