package com.bxm.doris.facade.service;


import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.AbtestExperimentDataResponse;
import com.bxm.doris.facade.model.DorisDataResponse;
import com.bxm.doris.facade.model.DorisRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface DorisFacadeService {


    /**
     * 查找总UV
     * @param dorisRequest
     * @return
     */
    @RequestMapping(value = "/getUvByParams")
    public ResponseEntity<Integer> getUvByParams(@RequestBody DorisRequest dorisRequest);

    /**
     * 根据条件查找各个维度的UV
     * @param dorisRequest
     * @return
     */
    @RequestMapping(value = "/getDataByParams")
    public ResponseEntity<List<DorisDataResponse>> getDataByParams(@RequestBody DorisRequest dorisRequest);

    /**
     * 根据实验id查询实验数据
     * @param experimentId
     * @return
     */
    @GetMapping("/getAbtestExperimentData")
    ResponseEntity<List<AbtestExperimentDataResponse>> getAbtestExperimentData(@RequestParam("experimentId") String experimentId);


}
