package com.bxm.doris.facade.service;


import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.*;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 事件分析功能facade
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface EventAnalysisFacadeService {

    /**
     * 根据日期广告位ID查询广告位发券收益结果
     *
     * @param thedate
     * @param positionId
     * @return
     */
    @RequestMapping(value = "/getPositionHairTicketData", method = RequestMethod.GET)
    ResponseEntity<PositionHairTicketResponse> getPositionHairTicketData(@RequestParam("thedate") String thedate, @RequestParam("positionId") String positionId);

    /**
     * 根据日期广告位ID查询广告位发券收益结果
     *
     * @param thedate
     * @param positionId
     * @return
     */
    @RequestMapping(value = "/getPositionHairTicketTop10Data", method = RequestMethod.GET)
    ResponseEntity<List<PositionHairTicketResponse>> getPositionHairTicketTop10Data(@RequestParam("thedate") String thedate, @RequestParam("positionId") String positionId);

    /**
     * 查询指定日期券在指定广告位或者大盘上的收益数据总和
     *
     * @param thedate
     * @param positionId
     * @param ticketId
     * @return
     */
    @RequestMapping(value = "/getTicketIncomeData", method = RequestMethod.GET)
    ResponseEntity<PositionHairTicketResponse> getTicketIncomeData(@RequestParam("thedate") String thedate, @RequestParam("positionId") String positionId, @RequestParam("ticketId") Long ticketId);

    /**
     * 获取指定广告位上的券指定时间的时段收益数据
     *
     * @param thedate
     * @param positionId
     * @param ticketId
     * @return
     */
    @RequestMapping(value = "/getTicketIncomeHourData", method = RequestMethod.GET)
    ResponseEntity<List<PositionHairTicketResponse>> getTicketIncomeHourData(@RequestParam("thedate") String thedate, @RequestParam("positionId") String positionId, @RequestParam("ticketId") Long ticketId);

    /**
     * 获取指定日期、广告位、券、时段的分钟数据
     *
     * @param thedate
     * @param positionId
     * @param ticketId
     * @return
     */
    @RequestMapping(value = "/getTicketIncomeMinutesData", method = RequestMethod.GET)
    ResponseEntity<List<PositionHairTicketResponse>> getTicketIncomeMinutesData(@RequestParam("thedate") String thedate, @RequestParam("positionId") String positionId, @RequestParam("ticketId") Long ticketId);


    /**
     * 获取券的参竟信息
     *
     * @param positionId
     * @param conTicketId
     * @param anaTicketId
     * @param startHour
     * @param endHour
     * @return
     */
    @RequestMapping(value = "/getPositionTicketGinsengHerbInfo", method = RequestMethod.GET)
    ResponseEntity<PositionTicketGinsengHerbResponse> getPositionTicketGinsengHerbInfo(@RequestParam("positionId") String positionId, @RequestParam("conTicketId") String conTicketId, @RequestParam("anaTicketId") Long anaTicketId, @RequestParam("startHour") String startHour, @RequestParam("endHour") String endHour);

    /**
     * 获取多维度参竟信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/getDataByParam", method = RequestMethod.POST)
    List<TicketGinsengHerbResponse> getDataByParam(@RequestBody EventAnalysisRequest request);

    /**
     * 获取广告位总发券量
     *
     * @param positionId
     * @param startHour
     * @param endHour
     * @return
     */
    @RequestMapping(value = "/getPositionHairPv", method = RequestMethod.GET)
    ResponseEntity<HairSumDataResponse> getPositionHairPv(@RequestParam("positionId") String positionId, @RequestParam("ticketIds") String ticketIds, @RequestParam("startHour") String startHour, @RequestParam("endHour") String endHour);


    @RequestMapping(value = "/getPositionDimensionPadding", method = RequestMethod.POST)
    ResponseEntity<List<PositionPaddingResponse>> getPositionDimensionPadding(@RequestBody PositionPaddingRequest request);
}