package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface PositionFacadeService {



    /**
     * 查询时间内产生曝光的广告位
     * @param beginDate 开始时间
     * @param endDate 结束时间
     * @return 广告位id
     */
    @GetMapping("/position/findHasExposeDataPositionId")
    List<String> findHasExposeDataPositionId(@RequestParam("beginDate") String beginDate, @RequestParam("endDate") String endDate);


}
