package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.AnalysisMediaFlowRequest;
import com.bxm.doris.facade.model.AnalysisMediaFlowResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface TicketFacadeService {

    /**
     * 查找一段时间内存在曝光数据的券id
     * @param beginDate 开始时间
     * @param endDate 结束时间
     * @return 券id
     */
    @GetMapping("/ticket/findHasExposeDataTicketId")
    List<Long> findHasExposeDataTicketId(@RequestParam("beginDate") String beginDate, @RequestParam("endDate") String endDate);

}
