package com.bxm.doris.facade.model;

import lombok.Data;

import java.util.List;

/**
 * @author zhangdong
 * @date 2025/1/8
 */
@Data
public class BudgetLayerRequest {
    /**
     * 开始时间 格式：%Y-%m-%d %H:%i:%s
     */
    private String beginTime;
    /**
     * 结束时间  格式：%Y-%m-%d %H:%i:%s
     */
    private String endTime;
    /**
     * 日期 格式 %Y%m%d
     */
    private List<String> dates;
    /**
     * 包含的广告位id
     */
    private List<String> includePositionIds;
    /**
     * 排除的广告位id
     */
    private List<String> excludePositionIds;
    /**
     * 根据消耗倒序 取前几
     */
    private Integer topNum;
}
