package com.bxm.doris.facade.model.datapark;

import java.math.BigDecimal;

/**
 * <h3>类的基本描述</h3>
 *
 * @author daill
 * @since V1.0.0, 2024/01/11 14:30
 */
public class PositionData extends DataCommon {

    public final static double DEFAULT_RATE = 0.0;

    public double getJoinRate() {
        if (null == getJoinUv() || null == getIndexUv() || getIndexUv() == 0) {
            return DEFAULT_RATE;
        }
        return (new BigDecimal(getJoinUv()).divide(new BigDecimal(getIndexUv()),BigDecimal.ROUND_HALF_UP, BigDecimal.ROUND_HALF_UP)).doubleValue();
    }

    public double getClickRate() {
        if (null == getClickPv() || null == getSendPv() || getSendPv() == 0) {
            return DEFAULT_RATE;
        }
        return (new BigDecimal(getClickPv()).divide(new BigDecimal(getSendPv()),BigDecimal.ROUND_HALF_UP, BigDecimal.ROUND_HALF_UP)).doubleValue();
    }
}
