package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.AnalysisMediaFlowRequest;
import com.bxm.doris.facade.model.AnalysisMediaFlowResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/10/24
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface AnalysisMediaFlowFacadeService {

    /**
     * 获取数据根据日期分组
     *
     * @param request
     * @return
     */
    @PostMapping("/getDataGroupByDateHour")
    ResponseEntity<List<AnalysisMediaFlowResponse>> getDataGroupByDateHour(@RequestBody AnalysisMediaFlowRequest request);

    /**
     * 获取数据根据行业分组
     * @param request
     * @return
     */
    @PostMapping("/getDataGroupByIndustry")
    ResponseEntity<List<AnalysisMediaFlowResponse>> getDataGroupByIndustry(@RequestBody AnalysisMediaFlowRequest request);


    /**
     * 获取数据根据广告位分组
     * @param request
     * @return
     */
    @PostMapping("/getDataGroupByPosition")
    ResponseEntity<List<AnalysisMediaFlowResponse>> getDataGroupByPosition(@RequestBody AnalysisMediaFlowRequest request);


}
